/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigation;

import java.util.HashSet;
import java.util.Set;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.navigation.NavigationContext;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigation.NavigationPointFactory;
import oracle.javatools.jndi.Names;

public abstract class NavigationManager
implements Addin {
    private static final String NAV_MGR_NAME = "ide/navigation-manager";
    public static final String VETO_NAVIGATION = "NavigationManager.VETO_NAVIGATION";
    protected static final Set<NavigationPointFactory> navigationPointFactories = new HashSet<NavigationPointFactory>();

    public static NavigationManager getNavigationManager() {
        return (NavigationManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)NAV_MGR_NAME);
    }

    public static void setNavigationManager(NavigationManager navigationManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)NAV_MGR_NAME, (Object)navigationManager);
    }

    public abstract boolean canNavigateBack();

    public abstract int navigateBack() throws Exception;

    public abstract boolean canNavigateForward();

    public abstract int navigateForward() throws Exception;

    public abstract int navigateTo(NavigationPoint var1) throws Exception;

    public abstract int navigateTo(NavigationPoint var1, boolean var2) throws Exception;

    public static NavigationPoint getNavigationPoint(NavigationContext navigationContext) {
        for (NavigationPointFactory navigationPointFactory : navigationPointFactories) {
            NavigationPoint navigationPoint = navigationPointFactory.createNavigationPoint(navigationContext);
            if (navigationPoint == null) continue;
            return navigationPoint;
        }
        return null;
    }

    public abstract void registerEditorNavigationPoint(Class var1, Class var2);

    public abstract void setLastEdit(Context var1);

    public abstract boolean canNavigateToLastEdit();

    public abstract int navigateToLastEdit() throws Exception;
}

