/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.FileContentPatternRecognizer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizersHook;
import oracle.javatools.data.HashStructure;

class PatternRecognizerHookHelper {
    static Map<File, List<FileContentPatternRecognizer.FileContentPatternRule>> findPatternMappings(HashStructure hs) {
        return Collections.unmodifiableMap(PatternRecognizerHookHelper.buildPatternMappings(hs));
    }

    private static Map<File, List<FileContentPatternRecognizer.FileContentPatternRule>> buildPatternMappings(HashStructure hs) {
        HashMap<File, List<FileContentPatternRecognizer.FileContentPatternRule>> mappings = new HashMap<File, List<FileContentPatternRecognizer.FileContentPatternRule>>();
        List patternRecognizers = hs.getAsList("content-pattern-recognizer");
        if (patternRecognizers == null) {
            return mappings;
        }
        for (Object o : patternRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            PatternRecognizerHookHelper.addPatternMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addPatternMapping(HashStructure hs, Map<File, List<FileContentPatternRecognizer.FileContentPatternRule>> mappings) {
        List patternsRoot = hs.getAsList("any-line-starting-with-pattern");
        if (patternsRoot == null) {
            return;
        }
        for (Object o : patternsRoot) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String extension = childHs.getString("extension/#text");
            int maxLines = childHs.getInt("max-lines-to-read/#text", 250);
            String[] patterns = PatternRecognizerHookHelper.patterns(childHs);
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            FileContentPatternRecognizer.FileContentPatternRule rule = new FileContentPatternRecognizer.FileContentPatternRule(maxLines, patterns, metaClass);
            RecognizersHook.addToMultimap(mappings, Recognizer.sanitizeExtension(extension), rule);
        }
    }

    private static String[] patterns(HashStructure hs) {
        List patternsList = hs.getAsList("patterns");
        if (patternsList == null) {
            return new String[0];
        }
        ArrayList<String> patterns = new ArrayList<String>();
        for (Object o : patternsList) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            patterns.addAll(PatternRecognizerHookHelper.patternElements(childHs));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private static List<String> patternElements(HashStructure hs) {
        ArrayList<String> patterns = new ArrayList<String>();
        List patternList = hs.getAsList("pattern");
        if (patternList == null) {
            return patterns;
        }
        for (Object pattern : patternList) {
            if (!(pattern instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)pattern;
            patterns.add(childHs.getString("#text"));
        }
        return patterns;
    }

    private PatternRecognizerHookHelper() {
    }
}

