/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.ide.model.RecognizersHook;
import oracle.ide.model.RootElementRecognizerHookHelper;
import oracle.ide.xml.XMLRecognizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Pair;

class NamespaceRecognizerHookHelper {
    private static Logger LOG = Logger.getLogger(RecognizersHook.class.getName());

    static Pair<Map<XMLRecognizer.NSElem, MetaClass<Node>>, Map<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>>> findNamespaceMappings(HashStructure hs) {
        HashMap<XMLRecognizer.NSElem, MetaClass<Node>> nsMappings = new HashMap<XMLRecognizer.NSElem, MetaClass<Node>>();
        HashMap<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>> attrMappings = new HashMap<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>>();
        List xmlRecognizers = hs.getAsList("xml-recognizer");
        if (xmlRecognizers != null) {
            for (Object o : xmlRecognizers) {
                if (!(o instanceof HashStructure)) continue;
                HashStructure childHs = (HashStructure)o;
                NamespaceRecognizerHookHelper.addNamespaceMapping(childHs, nsMappings, attrMappings);
            }
        }
        return new Pair(Collections.unmodifiableMap(nsMappings), Collections.unmodifiableMap(attrMappings));
    }

    private static void addNamespaceMapping(HashStructure hs, Map<XMLRecognizer.NSElem, MetaClass<Node>> mappings, Map<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>> attrMappings) {
        List namespaces = hs.getAsList("namespace");
        if (namespaces == null) {
            return;
        }
        for (Object o : namespaces) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String uri = childHs.getString("uri/#text");
            String elemName = childHs.getString("elem-name/#text");
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            RootElementRecognizerHookHelper.registerXMLExtension(childHs);
            if (metaClass == null) {
                LOG.warning("Invalid registration of XML recognizer registration. 'node-type' element was " + metaClass + ", 'uri' was " + uri + ", and 'elem-name' was " + elemName + " . 'namespace' text was " + childHs.getString("#text") + " and it should have been empty.");
                return;
            }
            XMLRecognizer.NSElem nsElem = new XMLRecognizer.NSElem(uri, elemName);
            Boolean result = NamespaceRecognizerHookHelper.hasAttributes(childHs, nsElem, metaClass, attrMappings, uri, elemName);
            if (result != Boolean.FALSE) continue;
            mappings.put(nsElem, metaClass);
        }
    }

    private static Boolean hasAttributes(HashStructure hs, XMLRecognizer.NSElem nsElem, MetaClass<Node> metaClass, Map<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>> attrMappings, String uri, String elemName) {
        HashStructure attributesHash = hs.getHashStructure("attributes");
        if (attributesHash != null) {
            String match = attributesHash.getString("match", "all");
            List attributesInHash = attributesHash.getAsList("attribute");
            if (attributesInHash == null) {
                LOG.warning("The attributes element of xml-recognizer " + uri + "/" + elemName + " should have at least one attribute child");
                return null;
            }
            ArrayList<XMLRecognizer.Attribute> attributeList = new ArrayList<XMLRecognizer.Attribute>(attributesInHash.size());
            for (Object a : attributesInHash) {
                if (!(a instanceof HashStructure)) {
                    LOG.warning("The attributes element of xml-recognizer " + uri + "/" + elemName + " has invalid attribute child");
                    return null;
                }
                HashStructure attributeHash = (HashStructure)a;
                String name = attributeHash.getString("name");
                String value = attributeHash.getString("value");
                if (name == null || name.trim().length() == 0 || value == null || value.trim().length() == 0) {
                    LOG.warning("The attributes element of xml-recognizer " + uri + "/" + elemName + " has null or empty name or value attribute");
                    return null;
                }
                XMLRecognizer.Attribute attribute = new XMLRecognizer.Attribute(name, value);
                attributeList.add(attribute);
            }
            XMLRecognizer.Attributes attributes = new XMLRecognizer.Attributes(attributeList, !"any".equals(match));
            Map<XMLRecognizer.Attributes, MetaClass<Node>> mapping = attrMappings.get(nsElem);
            if (mapping == null) {
                mapping = new LinkedHashMap<XMLRecognizer.Attributes, MetaClass<Node>>();
                attrMappings.put(nsElem, mapping);
            }
            mapping.put(attributes, metaClass);
            return true;
        }
        return false;
    }

    private NamespaceRecognizerHookHelper() {
    }
}

