/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.LazyLoadEvent;
import oracle.ide.model.LazyLoadListener;
import oracle.ide.model.LazyTraversable;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.ResourceUtils;

public class LazyLoadedTraversable
extends ProjectSettingsTraversablePanel
implements Traversable,
ApplyListener,
LazyTraversable {
    private JPanel basePanel = new JPanel();
    private JPanel notLoadedPanel = new JPanel();
    private final MetaClass traversableMetaClass;
    private final JButton loadButton;
    private Traversable wrapped;
    private static final GridBagConstraints c = new GridBagConstraints();
    private TraversableContext dataContext;
    private TraversableContext traversableContext;
    private String providerExtensionId;
    private transient ArrayList _lazyLoadListeners = new ArrayList(2);

    public LazyLoadedTraversable(MetaClass traversableMetaClass, String providerExtensionId) {
        this.basePanel.setLayout(new GridBagLayout());
        this.loadButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.loadButton, (String)PanelsArb.getString(12));
        this.traversableMetaClass = traversableMetaClass;
        this.providerExtensionId = providerExtensionId;
        this.notLoadedPanel.add(this.loadButton);
        this.basePanel.add((Component)this.notLoadedPanel, c);
        this.setUpUI();
    }

    private void setUpUI() {
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LazyLoadedTraversable.this.createAndEnterPanel();
            }
        });
    }

    private void createAndEnterPanel() {
        try {
            if (this.wrapped == null) {
                this.wrapped = (Traversable)this.traversableMetaClass.newInstance();
                if (this.dataContext != null) {
                    this.onEntry(this.dataContext);
                    this.dataContext = null;
                }
                if (this.traversableContext != null) {
                    this.onProjectPanelEntry(this.traversableContext);
                    this.traversableContext = null;
                }
            }
        }
        catch (Exception e) {
            String msg = "Unable to instantiate " + this.traversableMetaClass.getClassName();
            throw new RuntimeException(msg, e);
        }
        Component wrappedComponent = this.wrapped.getComponent();
        this.basePanel.remove(this.notLoadedPanel);
        this.basePanel.add(wrappedComponent, c);
        this.fireTraversableLoaded(new LazyLoadEvent(this, this.wrapped));
        this.basePanel.revalidate();
        this.basePanel.repaint();
    }

    @Override
    public void onEntry(TraversableContext dataContext) {
        if (this.wrapped != null) {
            this.wrapped.onEntry(dataContext);
        } else {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            if (registry.isFullyLoaded(this.providerExtensionId)) {
                this.createAndEnterPanel();
            } else {
                this.dataContext = dataContext;
            }
        }
    }

    @Override
    public Component getComponent() {
        return this.basePanel;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.wrapped != null) {
            this.wrapped.onExit(dataContext);
        }
    }

    public Object getExitTransition() {
        return this.wrapped == null ? null : this.wrapped.getExitTransition();
    }

    public String getHelpID() {
        return this.wrapped == null ? "f1_loadextension_html" : this.wrapped.getHelpID();
    }

    @Override
    public boolean isActingLazy() {
        return this.wrapped == null;
    }

    public void apply(ApplyEvent e) {
        if (!(this.wrapped instanceof ApplyListener)) {
            return;
        }
        ((ApplyListener)this.wrapped).apply(e);
    }

    public void cancel(ApplyEvent e) {
        if (!(this.wrapped instanceof ApplyListener)) {
            return;
        }
        ((ApplyListener)this.wrapped).cancel(e);
    }

    @Override
    public void onProjectPanelEntry(TraversableContext traversableContext) {
        if (this.traversableContext == null) {
            this.traversableContext = traversableContext;
        }
        if (!(this.wrapped instanceof ProjectSettingsTraversablePanel)) {
            return;
        }
        ((ProjectSettingsTraversablePanel)this.wrapped).onEntry(traversableContext);
    }

    @Override
    public String getDataKey() {
        if (!(this.wrapped instanceof ProjectSettingsTraversablePanel)) {
            return null;
        }
        return ((ProjectSettingsTraversablePanel)this.wrapped).getDataKey();
    }

    @Override
    public String[] getPropertyKeys() {
        if (!(this.wrapped instanceof ProjectSettingsTraversablePanel)) {
            return new String[0];
        }
        return ((ProjectSettingsTraversablePanel)this.wrapped).getPropertyKeys();
    }

    @Override
    public boolean isUserOnly() {
        if (!(this.wrapped instanceof ProjectSettingsTraversablePanel)) {
            return super.isUserOnly();
        }
        return ((ProjectSettingsTraversablePanel)this.wrapped).isUserOnly();
    }

    @Override
    public synchronized void addLazyLoadListener(LazyLoadListener listener) {
        if (listener == null) {
            return;
        }
        if (this._lazyLoadListeners == null) {
            this._lazyLoadListeners = new ArrayList(2);
        }
        this._lazyLoadListeners.add(listener);
    }

    @Override
    public synchronized void removeLazyLoadListener(LazyLoadListener listener) {
        if (listener != null && this._lazyLoadListeners != null) {
            this._lazyLoadListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTraversableLoaded(LazyLoadEvent lazyLoadEvent) {
        List list;
        LazyLoadedTraversable lazyLoadedTraversable = this;
        synchronized (lazyLoadedTraversable) {
            if (this._lazyLoadListeners == null) {
                return;
            }
            list = (List)this._lazyLoadListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((LazyLoadListener)list.get(i)).traversableLoaded(lazyLoadEvent);
        }
    }

    @Override
    @Deprecated
    public void addHierarchyListenerForLoading(HierarchyListener hierarchyListener) {
    }

    @Override
    @Deprecated
    public void removeHierarchyListenerForLoading(HierarchyListener hierarchyListener) {
    }

    static {
        LazyLoadedTraversable.c.gridy = 0;
        LazyLoadedTraversable.c.gridx = 0;
        LazyLoadedTraversable.c.gridheight = 1;
        LazyLoadedTraversable.c.gridwidth = 1;
        LazyLoadedTraversable.c.anchor = 18;
        LazyLoadedTraversable.c.weighty = 1.0;
        LazyLoadedTraversable.c.weightx = 1.0;
        LazyLoadedTraversable.c.fill = 1;
    }
}

