/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.model.AbstractHSAdapterDelegate;
import oracle.ide.model.HSAdapterDelegate;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;

public final class HSAdapterDelegateMediator {
    static final Logger LOGGER = Logger.getLogger(HSAdapterDelegateMediator.class.getName());
    private final Collection<HSAdapterDelegateProxy> m_proxies = new ArrayList<HSAdapterDelegateProxy>();
    private final Map<String, HSAdapterDelegate> m_FQN2delegateInstance = new ConcurrentHashMap<String, HSAdapterDelegate>();
    private static HSAdapterDelegateMediator INSTANCE = null;

    private HSAdapterDelegateMediator() {
    }

    public static HSAdapterDelegateMediator getMediator() {
        if (INSTANCE == null) {
            INSTANCE = new HSAdapterDelegateMediator();
        }
        return INSTANCE;
    }

    public void registerDelegate(String dataKey, String disabledText, URL iconURL, String parentElement, MetaClass<? extends HSAdapterDelegate> delegateMetaClass, String techScope, HSAdapterDelegate.Type type) {
        assert (parentElement != null);
        assert (dataKey != null);
        assert (delegateMetaClass != null);
        for (HSAdapterDelegateProxy proxy : this.m_proxies) {
            if (!proxy.getAdapterMetaClass().equals(delegateMetaClass)) continue;
            proxy.addRegistrationEntry(dataKey, parentElement, disabledText, iconURL, type);
            return;
        }
        HSAdapterDelegateProxy newProxy = new HSAdapterDelegateProxy(delegateMetaClass, techScope);
        newProxy.addRegistrationEntry(dataKey, parentElement, disabledText, iconURL, type);
        this.m_proxies.add(newProxy);
    }

    public boolean delegates(TechnologyScope techScope) {
        for (HSAdapterDelegateProxy proxy : this.m_proxies) {
            if (!proxy.appliesTo(techScope)) continue;
            return true;
        }
        return false;
    }

    public boolean isDelegated(String dataKey, String rootQName) {
        if (dataKey != null && rootQName != null) {
            AbstractHSAdapterDelegate.Entry hsAdapterImpl = this._findHSAdapterDelegateProxyEntry(rootQName, dataKey);
            return hsAdapterImpl != null && hsAdapterImpl.getType() == HSAdapterDelegate.Type.DELEGATE;
        }
        return false;
    }

    public boolean isDisabled(String dataKey, String rootQName) {
        if (dataKey != null && rootQName != null) {
            AbstractHSAdapterDelegate.Entry hsAdapterImpl = this._findHSAdapterDelegateProxyEntry(rootQName, dataKey);
            return hsAdapterImpl != null;
        }
        return false;
    }

    public Icon getDisabledIcon(String dataKey, String rootQName) {
        AbstractHSAdapterDelegate.Entry hsAdapterImpl;
        if (dataKey != null && rootQName != null && (hsAdapterImpl = this._findHSAdapterDelegateProxyEntry(rootQName, dataKey)) != null) {
            return hsAdapterImpl.getDisabledIcon();
        }
        return null;
    }

    public HSAdapterDelegate.Type getType(String dataKey, String rootQName) {
        AbstractHSAdapterDelegate.Entry hsAdapterImpl;
        if (dataKey != null && rootQName != null && (hsAdapterImpl = this._findHSAdapterDelegateProxyEntry(rootQName, dataKey)) != null) {
            return hsAdapterImpl.getType();
        }
        return null;
    }

    public String getDisabledText(String dataKey, String rootQName) {
        AbstractHSAdapterDelegate.Entry hsAdapterImpl;
        if (dataKey != null && rootQName != null && (hsAdapterImpl = this._findHSAdapterDelegateProxyEntry(rootQName, dataKey)) != null) {
            return hsAdapterImpl.getDisabledText();
        }
        return null;
    }

    public Component getPreview(String dataKey, String parentElement, HashStructureNode hsNode) {
        HSAdapterDelegate hsad = this._findHSAdapterDelegate(parentElement, dataKey);
        if (hsad != null) {
            return hsad.getPreview(dataKey, hsNode);
        }
        return null;
    }

    public Object delegateDataKey(String dataKey, String parentElement, HashStructureNode hsNode) {
        HSAdapterDelegate hsad = this._findHSAdapterDelegate(parentElement, dataKey);
        if (hsad != null) {
            return hsad.delegate(dataKey, hsNode);
        }
        return null;
    }

    public void pushValue(String dataKey, String parentElement, HashStructureNode hsNode, Object value) {
        HSAdapterDelegate hsad = this._findHSAdapterDelegate(parentElement, dataKey);
        if (hsad != null) {
            hsad.pushValue(dataKey, hsNode, value);
        }
    }

    private HSAdapterDelegate _findHSAdapterDelegate(String parentElement, String dataKey) {
        HSAdapterDelegateProxy proxy = null;
        for (HSAdapterDelegateProxy p : this.m_proxies) {
            AbstractHSAdapterDelegate.Entry entry = p.findEntry(dataKey, parentElement);
            if (entry == null) continue;
            proxy = p;
        }
        if (proxy != null) {
            String className = proxy.getAdapterMetaClass().getClassName();
            if (!this.m_FQN2delegateInstance.containsKey(className)) {
                this.m_FQN2delegateInstance.put(className, proxy);
            }
            return this.m_FQN2delegateInstance.get(className);
        }
        return null;
    }

    private AbstractHSAdapterDelegate.Entry _findHSAdapterDelegateProxyEntry(String parentElement, String dataKey) {
        for (HSAdapterDelegateProxy proxy : this.m_proxies) {
            AbstractHSAdapterDelegate.Entry entry = proxy.findEntry(dataKey, parentElement);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public boolean needsDelegation(HashStructureNode hsNode, HashStructure hsnHash) {
        if (hsNode == null || hsnHash == null) {
            return false;
        }
        if (hsNode instanceof Workspace) {
            return this._hasMavenProperties(hsnHash);
        }
        TechnologyScope tsc = (TechnologyScope)hsNode.getTransientProperties().get(TechnologyScope.class.getName());
        if (tsc != null) {
            return this.delegates(tsc);
        }
        HashStructure techScopeHS = hsnHash.getHashStructure(TechnologyScopeConfiguration.DATA_KEY);
        if (techScopeHS != null) {
            tsc = TechnologyScopeConfiguration.getInstance(techScopeHS).getTechnologyScope();
        }
        return tsc != null && this.delegates(tsc) && this._buildsWithMaven(hsnHash);
    }

    private boolean _hasMavenProperties(HashStructure hsnHash) {
        TechnologyScope scope = new TechnologyScope();
        scope.addTechScopeWithoutDependencies("Maven");
        if (this.delegates(scope)) {
            return this._buildsWithMaven(hsnHash);
        }
        return false;
    }

    private boolean _buildsWithMaven(HashStructure hsnHash) {
        String mavenConfigKey = "oracle.jdeveloper.maven.compiler.MavenConfiguration";
        String pomFileKey = "pomfileURL";
        String fullyQualifiedKey = "oracle.jdeveloper.maven.compiler.MavenConfiguration/pomfileURL";
        URL url = hsnHash.getURL("oracle.jdeveloper.maven.compiler.MavenConfiguration/pomfileURL");
        if (url != null) {
            return true;
        }
        HashStructure hash = hsnHash.getHashStructure("oracle.jdeveloper.maven.compiler.MavenConfiguration");
        return hash != null && (url = hash.getURL("oracle.jdeveloper.maven.compiler.MavenConfiguration/pomfileURL")) != null;
    }

    public HashStructure addDelegateIfNeeded(HashStructure hsnHash, HashStructureNode hsNode) {
        if (this.needsDelegation(hsNode, hsnHash)) {
            return HashStructure.newHashStructureFilteredImpl((HashStructure)hsnHash, (HashStructure.Filter)hsNode.createDelegatingFilter());
        }
        return hsnHash;
    }

    private class HSAdapterDelegateProxy
    extends AbstractHSAdapterDelegate {
        final MetaClass<? extends HSAdapterDelegate> m_delegateMeta;
        HSAdapterDelegate m_delegate;

        HSAdapterDelegateProxy(MetaClass<? extends HSAdapterDelegate> delegateMeta, String techScope) {
            super(techScope);
            this.m_delegate = null;
            this.m_delegateMeta = delegateMeta;
        }

        @Override
        public Object delegate(String dataKey, HashStructureNode hsNode) {
            this._ensureDelegateInitialized();
            return this.m_delegate.delegate(dataKey, hsNode);
        }

        @Override
        public void pushValue(String dataKey, HashStructureNode hsNode, Object value) {
            this._ensureDelegateInitialized();
            this.m_delegate.pushValue(dataKey, hsNode, value);
        }

        @Override
        public Component getPreview(String dataKey, HashStructureNode hsNode) {
            this._ensureDelegateInitialized();
            return this.m_delegate.getPreview(dataKey, hsNode);
        }

        private MetaClass<? extends HSAdapterDelegate> getAdapterMetaClass() {
            return this.m_delegateMeta;
        }

        private void _ensureDelegateInitialized() {
            if (this.m_delegate == null) {
                try {
                    this.m_delegate = (HSAdapterDelegate)this.m_delegateMeta.newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

