/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.extension.GlobalClassLoader;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedRegionMarker;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;

class GuardedSupport {
    private GuardedSupport() {
    }

    static GuardedSectionsProvider getDefaultProvider(URL fileURL, GuardedEditorSupport document) {
        String path;
        if (fileURL != null && !"jar".equals(fileURL.getProtocol()) && (path = fileURL.getPath()).endsWith(".java") && URLFileSystem.exists((URL)URLFactory.replacePathPart((URL)fileURL, (String)(path.substring(0, path.length() - 4) + "form")))) {
            try {
                Class<?> cls = Class.forName("org.netbeans.modules.java.guards.JavaGuardedSectionsFactory", true, GlobalClassLoader.INSTANCE.getClassLoader());
                GuardedSectionsFactory f = (GuardedSectionsFactory)cls.newInstance();
                return f.create(document);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return null;
    }

    static StyledDocument createGuardedDocument(TextBuffer textBuffer) {
        return textBuffer instanceof GuardedTextBuffer ? new GuardedDocument((GuardedTextBuffer)textBuffer) : null;
    }

    static Reader createGuardedReader(GuardedSectionsProvider readerProvider, InputStream inputStream, String encoding, TextBuffer textBufferToRead) {
        Charset cs;
        if (!(textBufferToRead instanceof GuardedTextBuffer)) {
            return null;
        }
        try {
            cs = Charset.forName(encoding);
        }
        catch (Exception ex) {
            cs = null;
        }
        Reader guardedReader = readerProvider.createGuardedReader(inputStream, cs);
        return new BufferReader(guardedReader, textBufferToRead);
    }

    static Writer createGuardedWriter(GuardedSectionsProvider writerProvider, OutputStream outputStream, String encoding) {
        Charset cs;
        try {
            cs = Charset.forName(encoding);
        }
        catch (Exception ex) {
            cs = null;
        }
        return writerProvider.createGuardedWriter(outputStream, cs);
    }

    private static class BufferReader
    extends Reader
    implements TextBufferListener {
        private Reader reader;

        BufferReader(Reader reader, TextBuffer textBuffer) {
            this.reader = reader;
            textBuffer.addTextBufferListener((TextBufferListener)this);
        }

        public void attributeUpdate(TextBuffer textBuffer, int a) {
            if (a == 4) {
                textBuffer.removeTextBufferListener((TextBufferListener)this);
                try {
                    this.reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void insertUpdate(TextBuffer tb, int i, int i1, char[] chars) {
        }

        public void removeUpdate(TextBuffer tb, int i, int i1, char[] chars) {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.reader.read(cbuf, off, len);
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.reader.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.reader.markSupported();
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return this.reader.read(target);
        }

        @Override
        public int read() throws IOException {
            return this.reader.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.reader.read(cbuf);
        }

        @Override
        public boolean ready() throws IOException {
            return this.reader.ready();
        }

        @Override
        public void reset() throws IOException {
            this.reader.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.reader.skip(n);
        }
    }

    private static class GuardedDocument
    implements StyledDocument,
    GuardedRegionMarker {
        private GuardedTextBuffer textBuffer;
        private GuardedSectionManager guardedManager;

        GuardedDocument(GuardedTextBuffer textBuffer) {
            this.textBuffer = textBuffer;
        }

        public void protectRegion(int offset, int length) {
            this.textBuffer.guard(offset, length);
        }

        public void unprotectRegion(int offset, int length) {
            this.textBuffer.unguard(offset, length);
        }

        @Override
        public int getLength() {
            return this.textBuffer.getLength();
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            try {
                return this.textBuffer.getString(offset, length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new BadLocationException(e.getMessage(), offset + length - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.textBuffer.writeLock();
            this.textBuffer.setGuardActive(false);
            try {
                this.textBuffer.insert(offset, str.toCharArray());
            }
            finally {
                this.textBuffer.setGuardActive(true);
                this.textBuffer.writeUnlock();
            }
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            this.textBuffer.writeLock();
            this.textBuffer.setGuardActive(false);
            try {
                this.textBuffer.remove(offset, length);
            }
            finally {
                this.textBuffer.setGuardActive(true);
                this.textBuffer.writeUnlock();
            }
        }

        @Override
        public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        }

        @Override
        public void putProperty(Object key, Object value) {
            if (GuardedSectionManager.class.equals(key) && value instanceof GuardedSectionManager) {
                this.guardedManager = (GuardedSectionManager)value;
            }
        }

        @Override
        public Object getProperty(Object key) {
            if (GuardedSectionManager.class.equals(key)) {
                return this.guardedManager;
            }
            return null;
        }

        @Override
        public Position createPosition(int offset) throws BadLocationException {
            return new TextBufferPosition(offset, (TextBuffer)this.textBuffer);
        }

        @Override
        public Style addStyle(String nm, Style parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeStyle(String nm) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Style getStyle(String nm) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogicalStyle(int pos, Style s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Style getLogicalStyle(int p) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getParagraphElement(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getCharacterElement(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Color getForeground(AttributeSet attr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Color getBackground(AttributeSet attr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Font getFont(AttributeSet attr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Position getStartPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Position getEndPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element[] getRootElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getDefaultRootElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void render(Runnable r) {
            throw new UnsupportedOperationException();
        }

        private static class TextBufferPosition
        implements Position {
            private OffsetMark offsetMark;

            private TextBufferPosition(int offset, TextBuffer textBuffer) {
                assert (textBuffer.getLength() > 0);
                this.offsetMark = textBuffer.addOffsetMark(offset);
            }

            @Override
            public int getOffset() {
                return this.offsetMark.getOffset();
            }
        }
    }
}

