/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.CollectionUtil;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class ContentSet
extends HashStructureAdapter {
    public static final String URL_PATH_KEY = "url-path";
    private static final String CONTENT_FOLDER_URL_KEY = "content-folder-url";
    private static final String CONSTITUENT_SETS_KEY = "constituent-sets";
    private static final String MISC_URLS_KEY = "misc-urls";
    private static PatternFilters _excludeJprJwsFilters;
    private final URLPath _urlPath;
    private final PatternFilters _patternFilters;
    private final IntersectedFilters _intersectedFilters;
    private ListStructure _miscList;
    private URLComparator _urlComparator;
    private final ArrayList<ContentSet> _constituentSets = new ArrayList();
    private final boolean _persistentComposite;
    private PatternFilters noAutoExpandFilters;
    public static final String FULL_NAME_KEY = "FULL_NAME";

    public ContentSet(HashStructure contentSetHash) {
        this(contentSetHash, true);
    }

    public ContentSet(HashStructure contentSetHash, boolean persistentComposite) {
        super(contentSetHash);
        this._urlPath = new URLPath((List)this._hash.getOrCreateListStructure(URL_PATH_KEY));
        this._patternFilters = PatternFilters.getInstance(this._hash);
        PatternFilters excludeJprJws = ContentSet.getExcludeJprJwsFilters();
        PatternFilters globalIgnores = GlobalIgnoreList.getPatternFilters();
        this._intersectedFilters = new IntersectedFilters(this._patternFilters, excludeJprJws, globalIgnores);
        ListStructure unionSetsList = this._hash.getListStructure(CONSTITUENT_SETS_KEY);
        if (unionSetsList != null) {
            for (Object obj : unionSetsList) {
                if (!(obj instanceof HashStructure)) continue;
                HashStructure hash = (HashStructure)obj;
                ContentSet contentSet = new ContentSet(hash);
                this._constituentSets.add(contentSet);
            }
        }
        this._persistentComposite = persistentComposite;
    }

    public static PatternFilters getExcludeJprJwsFilters() {
        if (_excludeJprJwsFilters == null) {
            _excludeJprJwsFilters = PatternFilters.getInstance(HashStructure.newInstance());
            _excludeJprJwsFilters.addInclude("**");
            _excludeJprJwsFilters.addExclude("**/*.jpr");
            _excludeJprJwsFilters.addExclude("**/*.jws");
        }
        return _excludeJprJwsFilters;
    }

    public static ContentSet getInstance(PropertyStorage project, String contentSetKey) {
        return new ContentSet(ContentSet.findOrCreate((PropertyStorage)project, (String)contentSetKey));
    }

    public String getContentSetName() {
        return this._hash.getFullName() != null ? this._hash.getFullName() : this._hash.getString(FULL_NAME_KEY);
    }

    public URLPath getURLPath() {
        return this._urlPath;
    }

    public URL getContentFolderURL() {
        return this._hash.getURL(CONTENT_FOLDER_URL_KEY);
    }

    public void setContentFolderURL(URL contentFolderURL) {
        this._hash.putURL(CONTENT_FOLDER_URL_KEY, contentFolderURL, true);
    }

    public URLPath getAllRootDirs() {
        URLPath roots = new URLPath();
        ContentSet.copyContentSetURLPathToURLPath(this, roots);
        return roots;
    }

    private static void copyContentSetURLPathToURLPath(ContentSet cs, URLPath path) {
        path.add(cs.getURLPath());
        int n = cs.countContentSets();
        for (int i = 0; i < n; ++i) {
            ContentSet cur = cs.getContentSet(i);
            ContentSet.copyContentSetURLPathToURLPath(cur, path);
        }
    }

    public PatternFilters getPatternFilters() {
        return this._patternFilters;
    }

    public boolean canHaveMember(URL url) {
        List entries = this._urlPath.asList();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            URL entry = (URL)iterator.next();
            String relPath = URLFileSystem.toRelativeSpec((URL)url, (URL)entry, (boolean)true);
            if (relPath == null || !this._intersectedFilters.isIncluded(relPath)) continue;
            return true;
        }
        for (ContentSet contentSet : this._constituentSets) {
            if (!contentSet.canHaveMember(url)) continue;
            return true;
        }
        ListStructure miscList = this.getMiscList();
        return miscList != null && miscList.contains((Object)url);
    }

    public void addMiscellaneousFile(URL url) {
        ListStructure miscList;
        if (url != null && !(miscList = this.getOrCreateMiscList()).contains((Object)url)) {
            miscList.add((Object)url);
        }
    }

    public boolean removeMiscellaneousFile(URL url) {
        ListStructure miscList;
        boolean result = false;
        if (url != null && (miscList = this.getMiscList()) != null) {
            result = miscList.remove((Object)url);
            this.maybeClearMiscList();
        }
        return result;
    }

    public void addContentSet(ContentSet contentSet) {
        if (this._persistentComposite) {
            ListStructure unionSetsList = this._hash.getOrCreateListStructure(CONSTITUENT_SETS_KEY);
            unionSetsList.add((Object)contentSet._hash);
        }
        this._constituentSets.add(contentSet);
    }

    public int countContentSets() {
        return this._constituentSets.size();
    }

    public ContentSet getContentSet(int index) {
        return this._constituentSets.get(index);
    }

    public ContentSet setContentSet(int index, ContentSet contentSet) {
        if (contentSet == null) {
            throw new IllegalArgumentException();
        }
        return this._constituentSets.set(index, contentSet);
    }

    public void removeAllContentSets() {
        ListStructure unionSetsList;
        if (this._persistentComposite && (unionSetsList = this._hash.getListStructure(CONSTITUENT_SETS_KEY)) != null) {
            unionSetsList.clear();
        }
        this._constituentSets.clear();
    }

    public void removeContentSet(int index) {
        ListStructure unionSetsList;
        if (this._persistentComposite && (unionSetsList = this._hash.getListStructure(CONSTITUENT_SETS_KEY)) != null) {
            unionSetsList.remove(index);
        }
        this._constituentSets.remove(index);
    }

    List flatten() {
        ArrayList flatContentSets = new ArrayList();
        this.flattenImpl(flatContentSets);
        return flatContentSets;
    }

    private void flattenImpl(ArrayList flatContentSets) {
        URLPath urlPath = this.getURLPath();
        for (URL url : urlPath) {
            ContentSet flattened = new ContentSet(HashStructure.newInstance());
            flattened.getURLPath().add(url);
            this.getPatternFilters().copyTo((Object)flattened.getPatternFilters());
            flatContentSets.add(flattened);
        }
        for (ContentSet contentSet : this._constituentSets) {
            contentSet.flattenImpl(flatContentSets);
        }
    }

    public List getDirectories(String relPath) {
        return this.getDirectories0(relPath, null, null);
    }

    public List getDirectories(String relPath, IntersectedFilters additionalFilters) {
        return this.getDirectories0(relPath, additionalFilters, null);
    }

    public List getDirectories(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        return this.getDirectories0(relPath, additionalFilters, urlFilter);
    }

    public List getFiles(String relPath) {
        return this.getFiles0(relPath, null, null);
    }

    public List getFiles(String relPath, IntersectedFilters additionalFilters) {
        return this.getFiles0(relPath, additionalFilters, null);
    }

    public List getFiles(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        return this.getFiles0(relPath, additionalFilters, urlFilter);
    }

    public List getFilesAndDirectories(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        return this.getFilesAndDirectories0(relPath, additionalFilters, urlFilter);
    }

    public List getNodes(String relPath) {
        return this.getNodes0(relPath, null, null);
    }

    public List getNodes(String relPath, IntersectedFilters additionalFilters) {
        return this.getNodes0(relPath, additionalFilters, null);
    }

    public List getNodes(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        return this.getNodes0(relPath, additionalFilters, urlFilter);
    }

    public URL toQualifiedURL(String relPath) {
        URL url;
        if (this._intersectedFilters.isIncluded(relPath) && (url = this._urlPath.toQualifiedURL(relPath)) != null) {
            return url;
        }
        for (ContentSet contentSet : this._constituentSets) {
            URL url2 = contentSet.toQualifiedURL(relPath);
            if (url2 == null) continue;
            return url2;
        }
        return null;
    }

    public String toRelativePath(URL url) {
        String relPath = this._urlPath.toRelativePath(url);
        if (relPath != null && this._intersectedFilters.isIncluded(relPath)) {
            return relPath;
        }
        for (ContentSet contentSet : this._constituentSets) {
            String relPath2 = contentSet.toRelativePath(url);
            if (relPath2 == null) continue;
            return relPath2;
        }
        return null;
    }

    public Iterator urlIterator(String relPath) {
        return this.urlIterator(relPath, null);
    }

    public Iterator urlIterator(String relPath, IntersectedFilters additionalFilters) {
        return this.urlIterator(relPath, additionalFilters, null);
    }

    public Iterator urlIterator(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        ContentLevel initialLevel;
        ContentLevel contentLevel = ContentLevel.newInstance(this, additionalFilters);
        if (relPath == null || relPath.equals("")) {
            initialLevel = contentLevel;
        } else {
            String relPathItem;
            ContentLevel curLevel = contentLevel;
            StringTokenizer st = new StringTokenizer(relPath, "/");
            while (st.hasMoreTokens() && ("".equals(relPathItem = st.nextToken() + "/") || (curLevel = curLevel.getContentLevel(relPathItem)) != null)) {
            }
            initialLevel = curLevel;
        }
        return new URLIterator(initialLevel, urlFilter);
    }

    public Iterator nodeIterator(String relPath) {
        return this.nodeIterator(relPath, null);
    }

    public Iterator nodeIterator(String relPath, IntersectedFilters additionalFilters) {
        return this.nodeIterator(relPath, additionalFilters, null);
    }

    public Iterator nodeIterator(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        final Iterator urlIter = this.urlIterator(relPath, additionalFilters, urlFilter);
        class Itr
        implements Iterator {
            Itr() {
            }

            @Override
            public boolean hasNext() {
                return urlIter.hasNext();
            }

            public Object next() {
                URL url = (URL)urlIter.next();
                try {
                    return NodeFactory.findOrCreate(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public void remove() {
                new UnsupportedOperationException().printStackTrace();
            }
        }
        return new Itr();
    }

    boolean isAutoExpand(URL url) {
        if (this.noAutoExpandFilters == null) {
            return true;
        }
        List entries = this._urlPath.asList();
        for (URL entry : entries) {
            String relPath = URLFileSystem.toRelativeSpec((URL)url, (URL)entry, (boolean)true);
            if (relPath == null || !this.noAutoExpandFilters.isIncluded(relPath)) continue;
            return false;
        }
        return true;
    }

    private ListStructure getOrCreateMiscList() {
        if (this._miscList == null) {
            this._miscList = this._hash.getOrCreateListStructure(MISC_URLS_KEY);
        }
        return this._miscList;
    }

    private ListStructure getMiscList() {
        if (this._miscList == null) {
            this._miscList = this._hash.getListStructure(MISC_URLS_KEY);
        }
        return this._miscList;
    }

    private void maybeClearMiscList() {
        if (this._miscList != null && this._miscList.size() <= 0) {
            this._hash.remove(MISC_URLS_KEY);
        }
    }

    private URLComparator getURLComparator() {
        if (this._urlComparator == null) {
            this._urlComparator = new URLComparator();
        }
        return this._urlComparator;
    }

    private IntersectedFilters combineWithFilters(IntersectedFilters additionalFilters) {
        return additionalFilters != null ? new IntersectedFilters(this._intersectedFilters, additionalFilters) : this._intersectedFilters;
    }

    private List getDirectories0(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        List list = this.getDirectoriesImpl(relPath, additionalFilters, urlFilter);
        CollectionUtil.sortListAndEliminateDuplicates(list, null);
        return list;
    }

    private List getDirectoriesImpl(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        ArrayList list;
        IntersectedFilters allFilters = this.combineWithFilters(additionalFilters);
        TriStateBoolean tsb = allFilters.inferFromFilters(relPath);
        if (tsb.isTrue() || tsb.isTriState()) {
            list = this._urlPath.getDirectories(relPath, urlFilter);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String dir = iter.next().toString();
                TriStateBoolean inference = allFilters.inferFromFilters(dir);
                if (!inference.isFalse()) continue;
                iter.remove();
            }
        } else {
            list = new ArrayList();
        }
        for (ContentSet contentSet : this._constituentSets) {
            list.addAll(contentSet.getDirectoriesImpl(relPath, additionalFilters, urlFilter));
        }
        return list;
    }

    private List getFiles0(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        List list = this.getFilesImpl(relPath, additionalFilters, urlFilter);
        CollectionUtil.sortListAndEliminateDuplicates(list, (Comparator)this.getURLComparator());
        return list;
    }

    private List getFilesImpl(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        ArrayList list;
        IntersectedFilters allFilters = this.combineWithFilters(additionalFilters);
        TriStateBoolean tsb = allFilters.inferFromFilters(relPath);
        if (tsb.isTrue() || tsb.isTriState()) {
            list = this._urlPath.getFiles(relPath, urlFilter);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                URL url = (URL)iter.next();
                String relFile = this._urlPath.toRelativePath(url);
                if (allFilters.isIncluded(relFile)) continue;
                iter.remove();
            }
        } else {
            list = new ArrayList();
        }
        for (ContentSet contentSet : this._constituentSets) {
            list.addAll(contentSet.getFilesImpl(relPath, additionalFilters, urlFilter));
        }
        return list;
    }

    private List getFilesAndDirectories0(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        List list = this.getFilesAndDirectoriesImpl(relPath, additionalFilters, urlFilter);
        CollectionUtil.sortListAndEliminateDuplicates(list, (Comparator)this.getURLComparator());
        return list;
    }

    private List getFilesAndDirectoriesImpl(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        List list = this._urlPath.getFilesAndDirectories(relPath, false, urlFilter);
        IntersectedFilters allFilters = this.combineWithFilters(additionalFilters);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            String relFile = this._urlPath.toRelativePath(url);
            if (relFile != null && relFile.endsWith("/")) {
                TriStateBoolean tsb = allFilters.inferFromFilters(relFile);
                if (!tsb.isFalse()) continue;
                iter.remove();
                continue;
            }
            if (allFilters.isIncluded(relFile)) continue;
            iter.remove();
        }
        for (ContentSet contentSet : this._constituentSets) {
            list.addAll(contentSet.getFilesAndDirectoriesImpl(relPath, additionalFilters, urlFilter));
        }
        return list;
    }

    private List getNodes0(String relPath, IntersectedFilters additionalFilters, URLFilter urlFilter) {
        List list = this.getFiles(relPath, additionalFilters, urlFilter);
        Iterator iter = list.iterator();
        ArrayList<Node> nodes = new ArrayList<Node>(list.size());
        while (iter.hasNext()) {
            try {
                nodes.add(NodeFactory.findOrCreate((URL)iter.next()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nodes;
    }

    void setNoAutoexpandFilters(PatternFilters noAexFilters) {
        if (noAexFilters != null) {
            this.noAutoExpandFilters = PatternFilters.getInstance(HashStructure.newInstance());
            for (PatternFilter f : noAexFilters.getFilters()) {
                if (f.isInclude()) {
                    this.noAutoExpandFilters.addInclude(f.getPattern());
                    continue;
                }
                this.noAutoExpandFilters.addExclude(f.getPattern());
            }
        }
    }

    public class URLIterator
    implements Iterator {
        private final URLFilter _urlFilter;
        private final LinkedList _levelQueue = new LinkedList();
        private Iterator _filesIter;
        private boolean _miscFilesChecked;

        public URLIterator(ContentLevel initialLevel, URLFilter urlFilter) {
            if (initialLevel != null) {
                this._levelQueue.add(initialLevel);
            }
            this._urlFilter = urlFilter;
        }

        @Override
        public boolean hasNext() {
            this.ensurePrepared();
            return this._filesIter.hasNext();
        }

        public Object next() {
            this.ensurePrepared();
            return this._filesIter.next();
        }

        @Override
        public void remove() {
            new UnsupportedOperationException().printStackTrace();
        }

        private void ensurePrepared() {
            if (this._filesIter == null || !this._filesIter.hasNext()) {
                while (this._levelQueue.size() > 0) {
                    ContentLevel curLevel = (ContentLevel)this._levelQueue.removeFirst();
                    List subdirs = curLevel.getDirectories();
                    Iterator subdirIter = subdirs.iterator();
                    ArrayList<ContentLevel> subdirLevels = new ArrayList<ContentLevel>();
                    while (subdirIter.hasNext()) {
                        String subdir = subdirIter.next().toString();
                        ContentLevel subdirLevel = curLevel.getContentLevel(subdir);
                        if (subdirLevel == null) continue;
                        subdirLevels.add(subdirLevel);
                    }
                    this._levelQueue.addAll(0, subdirLevels);
                    Collection<URL> files = this.getLevelFiles(curLevel);
                    if (this._urlFilter != null) {
                        Iterator<URL> filesIter = files.iterator();
                        while (filesIter.hasNext()) {
                            URL fileURL = filesIter.next();
                            if (this._urlFilter.accept(fileURL)) continue;
                            filesIter.remove();
                        }
                    }
                    this._filesIter = files.iterator();
                    if (!this._filesIter.hasNext()) continue;
                    return;
                }
                if (!this._miscFilesChecked) {
                    this._miscFilesChecked = true;
                    ListStructure miscFiles = ContentSet.this.getMiscList();
                    if (miscFiles != null) {
                        this._filesIter = miscFiles.iterator();
                        return;
                    }
                }
                this._filesIter = Collections.EMPTY_LIST.iterator();
            }
        }

        protected Collection<URL> getLevelFiles(ContentLevel curLevel) {
            return new ArrayList<URL>(curLevel.getFiles());
        }
    }
}

