/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.model.HSAdapterDelegate;
import oracle.ide.model.TechnologyScope;

public abstract class AbstractHSAdapterDelegate
implements HSAdapterDelegate {
    private String m_techScope = null;
    private Collection<Entry> m_registratons = null;

    protected AbstractHSAdapterDelegate() {
        this.m_registratons = new ArrayList<Entry>();
    }

    protected AbstractHSAdapterDelegate(String techScope) {
        this.m_techScope = techScope;
        this.m_registratons = new ArrayList<Entry>();
    }

    private Entry _findEntry(String dataKey, String parentElement) {
        for (Entry entry : this.m_registratons) {
            if (!entry.getParentElement().equals(parentElement) || !entry.getDataKey().equals(dataKey)) continue;
            return entry;
        }
        return null;
    }

    public final String getDisabledText(String dataKey, String parentElement) {
        Entry entry = this._findEntry(dataKey, parentElement);
        return entry != null ? entry.getDisabledText() : null;
    }

    public final Icon getDisabledIcon(String dataKey, String parentElement) {
        Entry entry = this._findEntry(dataKey, parentElement);
        return entry != null ? entry.getDisabledIcon() : null;
    }

    public final HSAdapterDelegate.Type getType(String dataKey, String parentElement) {
        Entry entry = this._findEntry(dataKey, parentElement);
        return entry != null ? entry.getType() : null;
    }

    public final boolean containsEntry(String dataKey, String parentElement) {
        return this._findEntry(dataKey, parentElement) != null;
    }

    public final Entry findEntry(String dataKey, String parentElement) {
        return this._findEntry(dataKey, parentElement);
    }

    final void addRegistrationEntry(String dataKey, String parentElement, String disabledText, URL iconURL, HSAdapterDelegate.Type type) {
        Entry entry = new Entry(dataKey, parentElement);
        entry.setType(type);
        entry.setDisabledText(disabledText);
        entry.setIconURL(iconURL);
        this.m_registratons.add(entry);
    }

    @Override
    public final boolean appliesTo(TechnologyScope techScope) {
        if (techScope != null && this.m_techScope != null) {
            TechnologyScope techScopeOfDelegate = new TechnologyScope();
            techScopeOfDelegate.addTechScopeWithoutDependencies(this.m_techScope);
            return techScope.contains(techScopeOfDelegate);
        }
        return false;
    }

    protected final void setTechScope(String techScope) {
        assert (techScope != null);
        this.m_techScope = techScope;
    }

    public static class Entry {
        private String m_parentElement;
        private String m_dataKey;
        private String m_disabledText;
        private URL m_iconURL;
        private Icon m_disabledIcon = null;
        private HSAdapterDelegate.Type m_type;

        protected Entry(String dataKey, String parentElement) {
            assert (dataKey != null);
            assert (parentElement != null);
            this.m_dataKey = dataKey;
            this.m_parentElement = parentElement;
        }

        protected void setDisabledText(String disabledText) {
            this.m_disabledText = disabledText;
        }

        public String getDisabledText() {
            return this.m_disabledText;
        }

        protected void setIconURL(URL iconURL) {
            this.m_iconURL = iconURL;
        }

        protected URL getIconURL() {
            return this.m_iconURL;
        }

        public Icon getDisabledIcon() {
            if (this.m_disabledIcon == null && this.m_iconURL != null) {
                this.m_disabledIcon = new ImageIcon(this.m_iconURL);
            }
            return this.m_disabledIcon;
        }

        protected void setType(HSAdapterDelegate.Type type) {
            this.m_type = type;
        }

        public HSAdapterDelegate.Type getType() {
            return this.m_type;
        }

        public final String getParentElement() {
            return this.m_parentElement;
        }

        public final String getDataKey() {
            return this.m_dataKey;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)object;
            if (!(this.m_parentElement != null ? this.m_parentElement.equals(other.m_parentElement) : other.m_parentElement == null)) {
                return false;
            }
            return this.m_dataKey != null ? this.m_dataKey.equals(other.m_dataKey) : other.m_dataKey == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this.m_parentElement == null ? 0 : this.m_parentElement.hashCode());
            result = 37 * result + (this.m_dataKey == null ? 0 : this.m_dataKey.hashCode());
            return result;
        }
    }
}

