/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.migration.NodeMigratorHelperReference;
import oracle.ide.model.Node;

public abstract class MigrationInfo {
    public static final String EARLIEST_VERSION = "900";
    public static final String POST_1013 = "10.1.3";
    public static final MigrationStatus MIGRATION_IO_ERROR = new MigrationStatus("migration backup error");
    public static final MigrationStatus MIGRATION_DONE = new MigrationStatus("migration done");
    public static final MigrationStatus MIGRATION_DONE_BUT_NOT_SAVED = new MigrationStatus("migration done but not saved");
    public static final MigrationStatus MIGRATION_ERROR = new MigrationStatus("migration error");
    public static final MigrationStatus MIGRATION_PENDING = new MigrationStatus("migration pending");
    public static final MigrationStatus MIGRATION_CANCELED = new MigrationStatus("migration canceled");
    public static final MigrationStatus MIGRATION_NOT_NEEDED = new MigrationStatus("migration not needed");
    public static final MigrationStatus MIGRATION_NOT_POSSIBLE = new MigrationStatus("migration not possible");
    public static final VersionStatus VERSION_UNKNOWN = new VersionStatus("version unknown");
    public static final VersionStatus VERSION_OLDER = new VersionStatus("version older");
    public static final VersionStatus VERSION_NEWER = new VersionStatus("version newer");
    public static final VersionStatus VERSION_CURRENT = new VersionStatus("version current");
    private final Node _node;
    private VersionStatus _versionStatus;
    private String _version;
    private MigrationStatus _migrationStatus;
    private URL _backupURL;
    private List<ErrorInformation> _errors = new ArrayList<ErrorInformation>();

    protected MigrationInfo(Node node) {
        this._node = node;
        this._migrationStatus = MIGRATION_PENDING;
    }

    public final Node getNode() {
        return this._node;
    }

    public Status getVersionStatus() {
        this.ensureVersionInfo();
        return this._versionStatus;
    }

    public Status getVersionStatusDirectly() throws IllegalStateException {
        if (this._versionStatus == null) {
            throw new IllegalStateException();
        }
        return this._versionStatus;
    }

    protected final void setVersionStatusDirectly(VersionStatus versionStatus) {
        this._versionStatus = versionStatus;
    }

    public MigrationStatus getMigrationStatus() {
        this.ensureVersionInfo();
        return this._migrationStatus;
    }

    public MigrationStatus getMigrationStatusDirectly() throws IllegalStateException {
        if (this._migrationStatus == null) {
            throw new IllegalStateException();
        }
        return this._migrationStatus;
    }

    public void setMigrationStatus(MigrationStatus status) {
        this._migrationStatus = status;
    }

    public String getVersion() {
        this.ensureVersionInfo();
        return this._version;
    }

    public final String getVersionDirectly() {
        return this._version;
    }

    public final Boolean isVersionPost1013() {
        return this._version != null && this._version.contains(".");
    }

    public final boolean hasErrors() {
        return !this._errors.isEmpty();
    }

    public final Iterator<ErrorInformation> getErrors() {
        return this._errors.iterator();
    }

    public final void addError(ErrorInformation errorInfo) {
        this._errors.add(errorInfo);
    }

    protected final void setVersionDirectly(String version) {
        this._version = version;
    }

    final URL getBackupURL() {
        return this._backupURL;
    }

    final void setBackupURL(URL backupURL) {
        this._backupURL = backupURL;
    }

    protected abstract void ensureVersionInfo();

    @Deprecated
    public NodeMigratorHelper[] getHelpers() {
        return new NodeMigratorHelper[0];
    }

    public NodeMigratorHelperReference[] getHelperReferences() {
        return new NodeMigratorHelperReference[0];
    }

    protected static String getVersionFromNamespaceURI(String namespaceURI) {
        int count = 0;
        StringTokenizer st = new StringTokenizer(namespaceURI, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (++count != 4) continue;
            return token;
        }
        return null;
    }

    public static final class ErrorInformation {
        private final Level _level;
        private final String _message;
        private final ActionType _actionType;

        public ErrorInformation(String message) {
            this(message, Level.SEVERE, ActionType.ABORT);
        }

        public ErrorInformation(String message, Level level) {
            this(message, level, ActionType.ABORT);
        }

        public ErrorInformation(String message, ActionType actionType) {
            this(message, Level.SEVERE, actionType);
        }

        public ErrorInformation(String message, Level level, ActionType actionType) {
            this._message = message;
            this._level = level;
            this._actionType = actionType;
        }

        public Level getLevel() {
            return this._level;
        }

        public String getMessage() {
            return this._message;
        }

        public ActionType getActionType() {
            return this._actionType;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ErrorInformation)) {
                return false;
            }
            ErrorInformation other = (ErrorInformation)object;
            if (!(this._level != null ? this._level.equals(other._level) : other._level == null)) {
                return false;
            }
            if (!(this._message != null ? this._message.equals(other._message) : other._message == null)) {
                return false;
            }
            return this._actionType != null ? this._actionType.equals((Object)other._actionType) : other._actionType == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this._level == null ? 0 : this._level.hashCode());
            result = 37 * result + (this._message == null ? 0 : this._message.hashCode());
            result = 37 * result + (this._actionType == null ? 0 : this._actionType.hashCode());
            return result;
        }

        public static enum ActionType {
            ABORT,
            PROMPT,
            CONTINUE;

        }
    }

    public static final class MigrationStatus
    extends Status {
        private MigrationStatus(String status) {
            super(status);
        }
    }

    public static final class VersionStatus
    extends Status {
        private VersionStatus(String status) {
            super(status);
        }
    }

    public static class Status {
        private final String _status;

        public String toString() {
            return this._status;
        }

        private Status(String status) {
            this._status = status;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!this.getClass().isInstance(object)) {
                return false;
            }
            Status other = (Status)object;
            return this._status != null ? this._status.equals(other._status) : other._status == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 37 + (this._status == null ? 0 : this._status.hashCode());
            return result;
        }
    }
}

