/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ide.extension.Extension;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory2;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.Dumpable;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MyModel;
import oracle.ide.keyboard.ResKeystrokeContext;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.util.Pair;

public final class KeyboardDockable
extends DockableWindow
implements DockableFactory2 {
    private static final String VIEW_TYPE_ID = "KF";
    private static final String DOCKABLE_ID = "KF.KF";
    private static KeyboardDockable INSTANCE = null;
    private JTable _table;
    private JComponent _GUI;
    private MyModel _model;
    private JList _list;
    private boolean alreadyInstalled;

    private KeyboardDockable() {
        super(DOCKABLE_ID);
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        this._model = new MyModel();
        kso.addChangeListener(this._model);
        INSTANCE = this;
    }

    static void initialize() {
        if (INSTANCE == null) {
            INSTANCE = new KeyboardDockable();
            ExtensionRegistry extRegistry = ExtensionRegistry.getExtensionRegistry();
            Extension esdkExt = extRegistry.findExtension("oracle.jdeveloper.esdk");
            if (esdkExt == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JMenu viewMenu = MenuManager.getJMenu("Window");
                        JMenuItem item = new JMenuItem("Keyboard");
                        Ide.getMenubar().add((Component)item, viewMenu);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                KeyboardDockable.showKeyboardDockable();
                            }
                        });
                    }
                });
            }
        }
    }

    static void showKeyboardDockable() {
        KeyboardDockable.initialize();
        DockStation dockStation = DockStation.getDockStation();
        boolean isvisible = dockStation.isDockableVisible(INSTANCE);
        if (!isvisible) {
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition(0);
            dockStation.dock(INSTANCE, dockingParam);
        }
        dockStation.setDockableVisible(INSTANCE, true);
    }

    @Override
    public String getTitleName() {
        return "Keyboard Dockable";
    }

    @Override
    public String getTabName() {
        return this.getTitleName();
    }

    @Override
    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public Component getGUI() {
        if (this._GUI == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
            this._table = new JTable(this._model);
            this._table.setColumnSelectionAllowed(false);
            this._table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    KeyboardDockable.this.whenMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    KeyboardDockable.this.whenMouseEvent(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!KeyboardDockable.this.whenMouseEvent(e)) {
                        TableColumnModel columnModel = KeyboardDockable.this._table.getColumnModel();
                        int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                        int column = KeyboardDockable.this._table.convertColumnIndexToModel(viewColumn);
                        if (e.getClickCount() == 1 && column != -1) {
                            KeyboardDockable.this._model.sort(column);
                        }
                    }
                }
            });
            this._table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    KeyboardDockable.this.whenMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    KeyboardDockable.this.whenMouseEvent(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    KeyboardDockable.this.whenMouseEvent(e);
                }
            });
            JScrollPane tableScrollPane = new JScrollPane(this._table);
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("1", tableScrollPane);
            final DefaultListModel<Pair> listModel = new DefaultListModel<Pair>();
            this._list = new JList(listModel){

                @Override
                public String getToolTipText(MouseEvent event) {
                    String ret = null;
                    int i = KeyboardDockable.this._list.locationToIndex(event.getPoint());
                    Pair elementAt = (Pair)listModel.getElementAt(i);
                    KeyStrokeContext contextAt = (KeyStrokeContext)elementAt.first;
                    ret = contextAt.getClass().getName();
                    return ret;
                }
            };
            this._list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Pair pair = (Pair)value;
                    KeyStrokeContext keyStrokeContext = (KeyStrokeContext)pair.first;
                    boolean global = Boolean.TRUE.equals(pair.second);
                    boolean isResContext = keyStrokeContext instanceof ResKeystrokeContext;
                    String label = keyStrokeContext.getName();
                    if (!global) {
                        label = label + "_local";
                    }
                    if (!isResContext) {
                        label = label + " (" + keyStrokeContext.getClass().getName() + ")";
                    }
                    Component ret = super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
                    if (!isSelected) {
                        if (isResContext) {
                            this.setForeground(list.getForeground());
                        } else {
                            this.setForeground(Color.RED);
                        }
                    }
                    return ret;
                }
            });
            Iterator allContexts = keyStrokeContextRegistry.getAllContexts();
            while (allContexts.hasNext()) {
                KeyStrokeContext keyStrokeContext = (KeyStrokeContext)allContexts.next();
                for (int i = 0; i < 2; ++i) {
                    boolean global = i == 0;
                    Set allActions = keyStrokeContext.getAllActions(global);
                    if (allActions == null || allActions.isEmpty()) continue;
                    listModel.addElement(new Pair((Object)keyStrokeContext, (Object)global));
                }
            }
            this._list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    KeyboardDockable.this.whenContextSelectionChanges();
                }
            });
            JScrollPane listScrollPane = new JScrollPane(this._list);
            tabbedPane.addTab("2", listScrollPane);
            this._GUI = tabbedPane;
        }
        return this._GUI;
    }

    private void whenContextSelectionChanges() {
        Pair selectedValue = (Pair)this._list.getSelectedValue();
        KeyStrokeContext keyStrokeContext = (KeyStrokeContext)selectedValue.first;
        boolean global = Boolean.TRUE.equals(selectedValue.second);
        StringBuffer buffer = new StringBuffer();
        Set allActions = keyStrokeContext.getAllActions(global);
        buffer.append("<context scope=\"" + (global ? "global" : "local") + "\">\n");
        List allPresets = keyStrokeContext.getAllPresets();
        if (allPresets != null && !allPresets.isEmpty()) {
            for (int i = 0; i < allPresets.size(); ++i) {
                Object preset = allPresets.get(i);
                StringBuffer presetBuffer = new StringBuffer();
                KeyStrokeMap presetKeyStrokeMap = keyStrokeContext.getPresetKeyStrokeMap(preset, global);
                Set<KeyStrokes> keystrokes = presetKeyStrokeMap.keySet();
                for (KeyStrokes keyStrokes : keystrokes) {
                    Integer binding = presetKeyStrokeMap.getBindingFor(keyStrokes);
                    int cmdID = binding;
                    String cmdName = Ide.findCmdName(cmdID);
                    if (cmdName != null) {
                        presetBuffer.append("    <map action=\"" + cmdName + "\">\n");
                        int length = keyStrokes.getLength();
                        for (int j = 0; j < length; ++j) {
                            KeyStroke keyStroke = keyStrokes.getKeyStroke(j);
                            presetBuffer.append("      <accel>" + KeyStroke2String.toString(keyStroke) + "</accel>\n");
                        }
                        presetBuffer.append("    </map>\n");
                    }
                    IdeAction action = IdeAction.find(cmdID);
                    allActions.remove(action);
                }
                if (presetBuffer.length() <= 0) continue;
                buffer.append("  <preset name=\"" + preset + "\">\n");
                buffer.append(presetBuffer);
                buffer.append("  </preset>\n");
            }
        }
        if (!allActions.isEmpty()) {
            buffer.append("  <allActions>\n");
            for (IdeAction action : allActions) {
                int commandId = action.getCommandId();
                String cmdName = Ide.findCmdName(commandId);
                if (cmdName == null) continue;
                buffer.append("    <map action=\"" + cmdName + "\"/>\n");
            }
            buffer.append("  </allActions>\n");
        }
        buffer.append("</context>\n");
        StringSelection ss = new StringSelection(buffer.toString());
        ClipboardStack.pushCurrentClipboard();
        IdeClipboard.getClipboard().setContents(ss, null);
    }

    @Override
    public Dockable getDockable(ViewId viewId) {
        return this;
    }

    @Override
    public void install() {
        if (this.alreadyInstalled) {
            return;
        }
        this.alreadyInstalled = true;
        final DockStation ds = DockStation.getDockStation();
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(0);
        ds.dock(this, dockingParam);
        Layouts.getLayouts().addLayoutResetListener(new LayoutResetListener(){

            @Override
            public void afterLayoutReset(LayoutResetEvent e) {
                ds.setDockableVisible(KeyboardDockable.this, false);
            }
        });
    }

    private boolean whenMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showCtxMenu(e);
            return true;
        }
        return false;
    }

    private void showCtxMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Dump");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardDockable.this.whenDump();
            }
        });
        popup.add(item);
        item = new JMenuItem("Copy");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardDockable.this.whenCopy();
            }
        });
        popup.add(item);
        Point pt = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)popup, (MouseEvent)e);
        popup.show(this._GUI, pt.x, pt.y);
    }

    private ArrayList collect(KeyStrokeContextRegistry kscr, String sPreset) {
        ArrayList list = new ArrayList(200);
        Iterator iKsc = kscr.getAllContexts();
        while (iKsc.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
            String sContext = ksc.getName();
            Object pc = KeyStrokeContextRegistry.searchPreset(ksc, sPreset);
            for (int i = 0; i < 2; ++i) {
                boolean bGlobal = i == 0;
                Set setActions = ksc.getAllActions(bGlobal);
                if (setActions == null) continue;
                KeyStrokeMap ksm = ksc.getPresetKeyStrokeMap(pc, bGlobal);
                KeyboardDockable.collect(list, sContext, ksm, setActions, bGlobal);
            }
        }
        return list;
    }

    private ArrayList collectCurrent(KeyStrokeContextRegistry kscr, KeyStrokeOptions kso) {
        ArrayList list = new ArrayList(200);
        KeyStrokeMap ksmGlobal = kso.getGlobalKeyMap();
        Iterator iKsc = kscr.getAllContexts();
        while (iKsc.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
            String sContext = ksc.getName();
            KeyStrokeMap ksmLocal = kso.getLocalKeyMap(ksc);
            for (int i = 0; i < 2; ++i) {
                boolean bGlobal = i == 0;
                Set setActions = ksc.getAllActions(bGlobal);
                if (setActions == null) continue;
                KeyboardDockable.collect(list, sContext, bGlobal ? ksmGlobal : ksmLocal, setActions, bGlobal);
            }
        }
        return list;
    }

    private static void collect(ArrayList list, String sContext, KeyStrokeMap ksm, Set setActions, boolean bGlobal) {
        for (Action a : setActions) {
            IdeAction ia;
            int nCmdID;
            if (!(a instanceof IdeAction) || (nCmdID = (ia = (IdeAction)a).getCommandId()) == -1) continue;
            IdeAction ideAction = IdeAction.find(nCmdID);
            if (ideAction != null) {
                List<KeyStrokes> l;
                String sActionName = (String)ideAction.getValue("Name");
                if (ksm == null || (l = ksm.getKeyStrokesFor((Integer)nCmdID)).isEmpty()) continue;
                for (KeyStrokes kss : l) {
                    if (kss == null) continue;
                    Dumpable d = new Dumpable(sContext, sActionName, bGlobal, kss);
                    list.add(d);
                }
                continue;
            }
            System.out.println("Strange: " + a.getValue("Name") + (bGlobal ? "" : "(local)") + " is not found by IdeAction.find()");
        }
    }

    private String dump2(KeyStrokeContextRegistry kscr, String sPresetName) {
        ArrayList list = this.collect(kscr, sPresetName);
        Collections.sort(list);
        String sName = "_" + sPresetName + ".kdf";
        this.dump2(list, sName, "_" + sPresetName);
        return sName;
    }

    private void dumpCurrent(KeyStrokeContextRegistry kscr, KeyStrokeOptions kso) {
        ArrayList list = this.collectCurrent(kscr, kso);
        Collections.sort(list);
        this.dump2(list, "_noname.kdf", "New Preset");
    }

    private void dump2(List list, String sFileName, String sPresetName) {
        try {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL url = er.getSystemDirectory(Ide.getProductID());
            File fOut = new File(url.getPath(), sFileName);
            FileWriter fw = new FileWriter(fOut);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter out = new PrintWriter(bw);
            out.println("<document>");
            out.println("  <preset name=\"" + sPresetName + "\">");
            String sContext = "!@!@";
            boolean bFirstCtx = true;
            for (Dumpable d : list) {
                if (!sContext.equals(d._sContext)) {
                    if (bFirstCtx) {
                        bFirstCtx = false;
                    } else {
                        out.println("    </context>");
                    }
                    out.println("    <context name=\"" + d._sContext + "\">");
                    sContext = d._sContext;
                }
                KeyboardDockable.dump(out, d._kss, d._sActionName, d._bGlobal);
            }
            out.println("    </context>");
            out.println("  </preset>");
            out.println("</document>");
            out.close();
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dump(PrintWriter out, KeyStrokes kss, String sActionName, boolean bGlobal) {
        out.println("      <map action=\"" + sActionName + "\" scope=\"" + (bGlobal ? "global" : "local") + "\">");
        if (kss != null) {
            for (int iKey = 0; iKey < kss.getLength(); ++iKey) {
                KeyStroke ks = kss.getKeyStroke(iKey);
                String sKey = KeyStroke2String.toString(ks);
                out.println("        <accel>" + sKey + "</accel>");
            }
        }
        out.println("      </map>");
    }

    private void whenDump() {
        StringBuffer msg = new StringBuffer();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        Iterator iPC = kscr.getAllPresets().iterator();
        String sSep = " ";
        msg.append("Created ");
        while (iPC.hasNext()) {
            String sPresetName = (String)iPC.next();
            System.out.println("==================================================");
            System.out.println("Generating " + sPresetName);
            String s = this.dump2(kscr, sPresetName);
            msg.append(sSep + s);
            sSep = ", ";
        }
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        this.dumpCurrent(kscr, kso);
        msg.append(" and _noname.kdf in the System directory");
        JOptionPane.showMessageDialog(this.getHostedComponent(), msg, "KeyboardDockable addin", 1);
    }

    private void whenCopy() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            for (int j = 0; j < this._model.getColumnCount(); ++j) {
                if (j != 0) {
                    sb.append('\t');
                }
                Object cell = this._model.getValueAt(i, j);
                String s = "";
                if (cell != null) {
                    s = cell.toString();
                }
                sb.append(s);
            }
            sb.append('\n');
        }
        Clipboard cb = IdeClipboard.getClipboard();
        StringSelection contents = new StringSelection(sb.toString());
        ClipboardStack.pushCurrentClipboard();
        cb.setContents(contents, null);
    }

    @Override
    public boolean canReinstall() {
        return false;
    }
}

