/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.ide.keyboard.KeyUtil;

public final class KeyStrokesConstraintFactory
implements KeyStrokesConstraint {
    public static final int TYPE_ALL = 0;
    public static final int TYPE_TEXT_EDITOR = 1;
    private static final KeyStrokesConstraint[] _store = new KeyStrokesConstraint[]{null, null};
    private final int _nType;

    private KeyStrokesConstraintFactory(int nType) {
        this._nType = nType;
    }

    @Override
    public boolean isAcceptableKey(KeyStrokes kss, KeyStroke ksNew) {
        switch (this._nType) {
            case 0: {
                return true;
            }
            case 1: {
                return !kss.isEmpty() || KeyUtil.isActionKey(ksNew) || ksNew.getKeyCode() == 127 || (ksNew.getModifiers() & 0xFFFFFFFE) != 0;
            }
        }
        return false;
    }

    public static KeyStrokesConstraint getConstraint(int nType) {
        if (_store[nType] == null) {
            KeyStrokesConstraintFactory._store[nType] = new KeyStrokesConstraintFactory(nType);
        }
        return _store[nType];
    }
}

