/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import oracle.ide.Ide;
import oracle.ide.keyboard.ActionElement;
import oracle.ide.keyboard.KeyStrokeArb;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.ShortcutElement;
import oracle.javatools.ui.table.GenericTableModel;

final class KeyStrokeTableModel
extends DefaultTableModel
implements GenericTableModel {
    static final int COLUMN_CATEGORY = 0;
    static final int COLUMN_COMMAND = 1;
    static final int COLUMN_SHORTCUT = 2;
    static final int COLUMN_CMD_ID_DEBUG = 3;
    static final int COLUMN_CMD_NAME_DEBUG = 4;
    static final String[] COLUMNS = new String[]{KeyStrokeArb.getString(0), KeyStrokeArb.getString(1), KeyStrokeArb.getString(2), "Command ID", "Command Name"};

    KeyStrokeTableModel() {
        super.setColumnIdentifiers(COLUMNS);
    }

    public int getColumnAlignment(int column) {
        return 2;
    }

    public boolean canHide(int column) {
        return column != 1;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    String getCategory(int row) {
        return (String)this.getValueAt(row, 0);
    }

    ActionElement getActionElement(int row) {
        return (ActionElement)this.getValueAt(row, 1);
    }

    ShortcutElement getShortcutElement(int row) {
        return (ShortcutElement)this.getValueAt(row, 2);
    }

    Vector getFullRow(int row) {
        return this.getDataVector().get(row);
    }

    void shortcutRemoved(int row) {
        super.setValueAt(null, row, 2);
    }

    void shortcutAdded(int row, ShortcutElement shortcut) {
        super.setValueAt(shortcut, row, 2);
    }

    void clear() {
        this.setRowCount(0);
    }

    void addRow(String category, ActionElement action, ShortcutElement shortcut) {
        Object[] rowData = this.newRow(category, action, shortcut);
        super.addRow(rowData);
    }

    private Object[] newRow(String category, ActionElement action, ShortcutElement shortcut) {
        Object[] rowData = new Object[COLUMNS.length];
        rowData[0] = category;
        rowData[1] = action;
        rowData[2] = shortcut;
        rowData[3] = action._act.getCommandId();
        rowData[4] = Ide.findCmdName(action._act.getCommandId());
        return rowData;
    }

    int duplicateRow(int row) {
        Object[] rowData = this.newRow(this.getCategory(row), this.getActionElement(row), null);
        int newRow = row + 1;
        super.insertRow(newRow, rowData);
        return newRow;
    }

    void removeShortcutsStartingWith(KeyStrokes kss) {
        Vector<Vector> v = this.getDataVector();
        for (int i = 0; i < v.size(); ++i) {
            Vector rowData = v.get(i);
            if (!this.maybeRemoveConflict(kss, rowData)) continue;
            this.fireTableCellUpdated(i, 2);
        }
    }

    private boolean maybeRemoveConflict(KeyStrokes kss, Vector rowData) {
        ShortcutElement shortcut = (ShortcutElement)rowData.get(2);
        if (shortcut != null && shortcut._kss.startWith(kss)) {
            rowData.set(2, null);
            return true;
        }
        return false;
    }
}

