/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class HelpDefinitions
extends HashStructureAdapter {
    private List<MetaClass> _browseSymbolResolvers;
    private List<MetaClass> _callbackWizardHandlers;
    private Map<String, MetaClass> _callbackMap;

    private HelpDefinitions(HashStructure hash) {
        super(hash);
    }

    public static HelpDefinitions getInstance(HashStructure hash) {
        return new HelpDefinitions(hash);
    }

    public List<MetaClass> getBrowseSymbolResolvers() {
        if (this._browseSymbolResolvers == null) {
            this._browseSymbolResolvers = this.getMetaClassList("browseSymbolResolver-class");
        }
        return this._browseSymbolResolvers;
    }

    public List<MetaClass> getCallbackWizardHandlers() {
        if (this._callbackWizardHandlers == null) {
            this._callbackWizardHandlers = this.getMetaClassList("callbackWizardHandler-class");
        }
        return this._callbackWizardHandlers;
    }

    public Map<String, MetaClass> getCallbackClasses() {
        if (this._callbackMap == null) {
            List hashList = this._hash.getAsList("callback");
            if (hashList == null || hashList.size() == 0) {
                this._callbackMap = Collections.EMPTY_MAP;
            } else {
                this._callbackMap = new HashMap<String, MetaClass>(hashList.size());
                for (HashStructure h : hashList) {
                    LazyClassAdapter adapter = LazyClassAdapter.getInstance(h);
                    String id = h.getString("id");
                    MetaClass metaClass = adapter.getMetaClass("class");
                    this._callbackMap.put(id, metaClass);
                }
            }
        }
        return this._callbackMap;
    }

    private List<MetaClass> getMetaClassList(String name) {
        ArrayList retval;
        List hashList = this._hash.getAsList(name);
        if (hashList == null || hashList.size() == 0) {
            retval = Collections.EMPTY_LIST;
        } else {
            retval = new ArrayList(hashList.size());
            for (HashStructure h : hashList) {
                LazyClassAdapter adapter = LazyClassAdapter.getInstance(h);
                retval.add(adapter.getMetaClass("#text"));
            }
        }
        return retval;
    }
}

