/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules.functions;

import java.net.URL;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class ProjectContainsPath
extends RuleFunction {
    @Override
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        URL projectParentFolder;
        RuleFunctionParameter path = this.getRequiredParameterOrThrow(parameters, "path");
        Context ideContext = ruleContext.getIdeContext();
        Project project = ideContext.getProject();
        if (project != null && (projectParentFolder = URLFileSystem.getParent((URL)project.getURL())) != null) {
            return URLFileSystem.exists((URL)URLFactory.newURL((URL)projectParentFolder, (String)path.getValue()));
        }
        return false;
    }
}

