/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.ExtensionProcessorContext;
import oracle.ide.extension.ExtensionProcessorPlugin;
import oracle.ide.osgi.boot.api.IdeMacros;

public class PropertiesExtensionProcessorPlugin
extends ExtensionProcessorPlugin {
    private File file;
    private Map<String, String> values;

    public PropertiesExtensionProcessorPlugin(File file) {
        this.file = file;
    }

    @Override
    public Set<String> getSupportedMacros(ExtensionProcessorContext context) {
        if (this.values == null) {
            try {
                this.values = IdeMacros.loadMacroFile((Path)this.file.toPath());
            }
            catch (IOException | InvalidPathException e) {
                this.values = Collections.emptyMap();
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "exception loading extension macro definitions from " + this, e);
            }
        }
        return this.values.keySet();
    }

    private String resolve(String path, File directory) {
        if (path.startsWith("file:") && (path = path.substring("file:".length())).length() > 0 && !new File(path).isAbsolute()) {
            path = new File(directory, path).getAbsolutePath();
        }
        return path;
    }

    @Override
    public String expandValue(ExtensionProcessorContext context, String macroName) {
        return this.values.get(macroName);
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

