/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookListener;

public class HashStructureHookAggregator {
    private final HashStructureHookListener hookListener;
    private final ElementName hookName;
    private boolean initialized;

    public HashStructureHookAggregator(ElementName hookName, HashStructureHookListener listener) {
        if (null == hookName) {
            throw new IllegalArgumentException("Hook name must not be null");
        }
        this.hookName = hookName;
        if (null == listener) {
            throw new IllegalArgumentException("HashStructureHookListener must not be null");
        }
        this.hookListener = listener;
    }

    public final synchronized void initialize() {
        if (!this.isInitialized()) {
            HashStructureHook hook = this.getHook();
            if (null == hook) {
                return;
            }
            hook.addHashStructureHookListener(this.getHookListener());
            this.initialized = true;
        }
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    protected HashStructureHook getHook() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        HashStructureHook hook = (HashStructureHook)registry.getHook(this.getHookName());
        return hook;
    }

    public HashStructureHookListener getHookListener() {
        return this.hookListener;
    }

    public ElementName getHookName() {
        return this.hookName;
    }
}

