/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerElement;
import oracle.ide.docking.DrawerEntry;
import oracle.ide.docking.DrawerModel;
import oracle.ide.docking.DrawerPanel;
import oracle.ide.layout.ViewId;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;

public class DrawerDockableWindow
extends DockableWindow {
    public static final int DROP_DOWN_ACTION_ID = Ide.createCmdID("DDW.dropDown");
    public static final int RESTORE_ACTION_ID = Ide.createCmdID("DDW.Restore");
    public static final int MOVE_ACTION_ID = Ide.createCmdID("DDW.Move");
    public static final int SIZE_ACTION_ID = Ide.createCmdID("DDW.Size");
    public static final int FLOAT_ACTION_ID = Ide.createCmdID("DDW.Float");
    public static final int MINIMIZE_ACTION_ID = Ide.createCmdID("DDW.Minimize");
    public static final int MAXIMIZE_ACTION_ID = Ide.createCmdID("DDW.Maximize");
    private final DrawerModel _model;
    private JPanel _ui;
    private String _tabName;
    private String _titleName;
    private JComponent _topComponent;
    private Icon _icon;
    private DrawerPanel _drawerPanel;
    private StructuredPropertyAccess _savedPanelLayout;
    private final DrawerController _controller = new DrawerController();
    private StructuredPropertyAccess _tempSavedPanelLayout;

    protected final void storeSavedPanelLayout() {
        this._tempSavedPanelLayout = this._savedPanelLayout;
    }

    protected final void restoreSavedPanelLayout() {
        this._savedPanelLayout = this._tempSavedPanelLayout;
    }

    public final void addDelegateController(Controller delegate) {
        this._controller.addDelegateController(delegate);
    }

    private boolean moreThanOneVisibleDrawer() {
        return this._drawerPanel.getDrawers().size() > 1;
    }

    public DrawerDockableWindow(String viewId) {
        super(viewId);
        DockStation dockStation = DockStation.getDockStation();
        this._model = dockStation.createDrawerModel(this);
    }

    public final void setTopComponent(JComponent topComponent) {
        this._topComponent = topComponent;
    }

    public final DrawerModel getModel() {
        return this._model;
    }

    private JComponent getTopComponent() {
        return this._topComponent;
    }

    @Override
    public final Controller getController() {
        return this._controller;
    }

    @Override
    public Component getGUI() {
        if (this._ui == null) {
            this._drawerPanel = this._model.createDrawerPanel(this);
            this._ui = new JPanel(new BorderLayout());
            JComponent topComponent = this.getTopComponent();
            if (topComponent != null) {
                this._ui.add((Component)topComponent, "North");
            }
            this._ui.add((Component)this._drawerPanel, "Center");
            if (this._savedPanelLayout != null) {
                this._drawerPanel.loadLayout(this._savedPanelLayout);
                this._savedPanelLayout = null;
            }
        }
        return this._ui;
    }

    public final void setTabName(String tabName) {
        this._tabName = tabName;
    }

    @Override
    public String getTabName() {
        return this._tabName;
    }

    public final void setTitleName(String titleName) {
        this._titleName = titleName;
    }

    @Override
    public String getTitleName() {
        return this._titleName;
    }

    @Override
    public Icon getTabIcon() {
        return this._icon;
    }

    public List<? extends DockableHolder> getContainedHolders() {
        return this._model.getEntries();
    }

    public final void setIcon(Icon icon) {
        this._icon = icon;
    }

    public final Dockable getDockable(DrawerElement drawerElement) {
        int i = this._model.indexOf(drawerElement);
        DrawerEntry entry = this._model.getEntry(i);
        return entry.getDockable();
    }

    public final boolean removeEntry(DockableWindow dockable) {
        return false;
    }

    @Override
    public final void saveLayout(PropertyAccess p) {
        StructuredPropertyAccess propertyAccess = (StructuredPropertyAccess)p;
        for (DrawerEntry drawerEntry : this._model.getEntries()) {
            DefaultStructuredPropertyAccess child = new DefaultStructuredPropertyAccess("DrawerModel.Entry");
            DockableWindow dockable = drawerEntry.getDockable();
            String uniqueName = dockable.getUniqueName();
            child.setProperty("UniqueName", uniqueName);
            child.setProperty("State", drawerEntry.getState().name());
            propertyAccess.appendChild(child);
            DefaultStructuredPropertyAccess chilPropertyAccess = new DefaultStructuredPropertyAccess("Layout");
            dockable.saveLayout(chilPropertyAccess);
            child.appendChild(chilPropertyAccess);
        }
        if (this._drawerPanel != null) {
            DefaultStructuredPropertyAccess panelLayout = new DefaultStructuredPropertyAccess("PanelLayout");
            this._drawerPanel.saveLayout(panelLayout);
            propertyAccess.appendChild(panelLayout);
        } else if (this._savedPanelLayout != null) {
            propertyAccess.appendChild(this._savedPanelLayout);
        }
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("user");
        this.saveLayoutImpl(defaultStructuredPropertyAccess);
        propertyAccess.appendChild(defaultStructuredPropertyAccess);
    }

    @Override
    public final void loadLayout(PropertyAccess p) {
        DockStation dockStation = DockStation.getDockStation();
        StructuredPropertyAccess propertyAccess = (StructuredPropertyAccess)p;
        Iterator childNodes = propertyAccess.getChildNodes("DrawerModel.Entry");
        while (childNodes.hasNext()) {
            ViewId viewId;
            DockableWindow dockable;
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            String uniqueName = child.getProperty("UniqueName", null);
            if (uniqueName == null || (dockable = (DockableWindow)dockStation.findDockable(viewId = new ViewId(uniqueName))) == null) continue;
            String stateValue = child.getProperty("State", DrawerModel.State.VISIBLE.name());
            DrawerModel.State state = DrawerModel.State.valueOf(stateValue);
            StructuredPropertyAccess childPropertyAccess = child.getChildNode("Layout");
            StructuredPropertyAccess layoutPropertyAccess = childPropertyAccess == null ? new DefaultStructuredPropertyAccess("Layout") : childPropertyAccess;
            dockable.loadLayout(layoutPropertyAccess);
            this._model.add(dockable, state);
        }
        this._savedPanelLayout = propertyAccess.getChildNode("PanelLayout");
        StructuredPropertyAccess childNode = propertyAccess.getChildNode("user");
        if (childNode != null) {
            this.loadLayoutImpl(childNode);
        }
    }

    protected void saveLayoutImpl(StructuredPropertyAccess propertyAccess) {
    }

    protected void loadLayoutImpl(StructuredPropertyAccess propertyAccess) {
    }

    public final void expand(DockableWindow dockableWindow) {
        int pos = this._model.indexOf(dockableWindow);
        assert (pos >= 0);
        DrawerEntry entry = this._model.getEntry(pos);
        DrawerElement drawerElement = (DrawerElement)entry.getOrCreateComponent();
        this._drawerPanel.toggle(Collections.singletonList(drawerElement), null, false);
    }

    public final void togglePannels(List<DockableWindow> expand, List<DockableWindow> collapse, boolean animate) {
        assert (expand == null || this._model.getDockables().containsAll(expand));
        assert (collapse == null || this._model.getDockables().containsAll(collapse));
        ArrayList<DrawerElement> expandDrawerElements = this.getDrawerElements(expand);
        ArrayList<DrawerElement> collapseDrawerElements = this.getDrawerElements(collapse);
        this._drawerPanel.toggle(expandDrawerElements, collapseDrawerElements, animate);
    }

    private ArrayList<DrawerElement> getDrawerElements(List<DockableWindow> dockableWindows) {
        ArrayList<DrawerElement> drawerElements;
        if (dockableWindows != null) {
            drawerElements = new ArrayList<DrawerElement>();
            for (DockableWindow dockableWindow : dockableWindows) {
                int pos = this._model.indexOf(dockableWindow);
                DrawerEntry entry = this._model.getEntry(pos);
                DrawerElement drawerElement = (DrawerElement)entry.getOrCreateComponent();
                drawerElements.add(drawerElement);
            }
        } else {
            drawerElements = null;
        }
        return drawerElements;
    }

    public void minimize(DockableWindow dockableWindow) {
        int index = this._model.indexOf(dockableWindow);
        DrawerEntry entry = this._model.getEntry(index);
        DrawerElement component = (DrawerElement)entry.getComponent();
        assert (component != null);
        this._drawerPanel.minimize(component, true);
        this._model.setState(index, DrawerModel.State.MINIMIZED);
    }

    public void restore(DockableWindow dockableWindow) {
        int index = this._model.indexOf(dockableWindow);
        DrawerEntry entry = this._model.getEntry(index);
        this._drawerPanel.restore(entry, false);
    }

    public void show(DockableWindow dockableWindow) {
        int index = this._model.indexOf(dockableWindow);
        DrawerEntry drawerEntry = this._model.getEntry(index);
        this._drawerPanel.show(drawerEntry);
    }

    public void hide(DockableWindow dockableWindow) {
        int index = this._model.indexOf(dockableWindow);
        DrawerEntry drawerEntry = this._model.getEntry(index);
        if (this._drawerPanel != null) {
            this._drawerPanel.hide(drawerEntry);
        }
    }

    class DrawerController
    implements Controller {
        private final List<Controller> delegates = new ArrayList<Controller>();

        DrawerController() {
        }

        void addDelegateController(Controller delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("Cannot add null delegates to this controller");
            }
            this.delegates.add(delegate);
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (this.eventHandledByDelegates(action, context)) {
                return true;
            }
            if (this.unimplementedHandled(action)) {
                return true;
            }
            return this.minimizeHandled(action, context);
        }

        private boolean eventHandledByDelegates(IdeAction action, Context context) {
            if (this.delegates.isEmpty()) {
                return false;
            }
            for (Controller delegate : this.delegates) {
                if (!delegate.handleEvent(action, context)) continue;
                return true;
            }
            return false;
        }

        private boolean unimplementedHandled(IdeAction action) {
            if (!this.isUnimplementedAction(action)) {
                return false;
            }
            action.setEnabled(false);
            return true;
        }

        private boolean minimizeHandled(IdeAction action, Context context) {
            if (!this.isMinimizeAction(action)) {
                return false;
            }
            DrawerDockableWindow.this.minimize(this.view(context));
            return true;
        }

        private DockableWindow view(Context context) {
            return (DockableWindow)context.getView();
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (this.updateHandledByDelegates(action, context)) {
                return true;
            }
            if (this.unimplementedUpdated(action)) {
                return true;
            }
            return this.minimizeUpdated(action);
        }

        private boolean updateHandledByDelegates(IdeAction action, Context context) {
            if (this.delegates.isEmpty()) {
                return false;
            }
            for (Controller delegate : this.delegates) {
                if (!delegate.update(action, context)) continue;
                return true;
            }
            return false;
        }

        private boolean isMinimizeAction(IdeAction action) {
            return action.getCommandId() == MINIMIZE_ACTION_ID;
        }

        private boolean isUnimplementedAction(IdeAction action) {
            int commandId = action.getCommandId();
            return commandId == RESTORE_ACTION_ID || commandId == MOVE_ACTION_ID || commandId == SIZE_ACTION_ID || commandId == MAXIMIZE_ACTION_ID || commandId == FLOAT_ACTION_ID;
        }

        private boolean unimplementedUpdated(IdeAction action) {
            if (!this.isUnimplementedAction(action)) {
                return false;
            }
            action.setEnabled(false);
            return true;
        }

        private boolean minimizeUpdated(IdeAction action) {
            if (!this.isMinimizeAction(action)) {
                return false;
            }
            this.disableIfOnlyOneVisibleDrawer(action);
            return true;
        }

        private void disableIfOnlyOneVisibleDrawer(IdeAction action) {
            action.setEnabled(DrawerDockableWindow.this.moreThanOneVisibleDrawer());
        }
    }
}

