/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import oracle.ide.controls.elementtree.ElementRegistry;
import oracle.ide.controls.elementtree.ElementTreeNode;
import oracle.ide.controls.elementtree.HierarchyChangeEvent;
import oracle.ide.controls.elementtree.HierarchyChangeListener;
import oracle.ide.model.Element;

public final class ElementTreeRootNode
extends ElementTreeNode {
    private ElementRegistry _registry;
    private HierarchyChangeListener _listener;

    public ElementTreeRootNode(Element element) {
        this(new ElementRegistry(), element);
    }

    public ElementTreeRootNode(ElementRegistry registry, Element element) {
        super(element);
        this._registry = registry;
    }

    @Override
    public ElementRegistry getElementRegistry() {
        return this._registry;
    }

    void addHierarchyListener(HierarchyChangeListener listener) {
        assert (this._listener == null);
        this._listener = listener;
        this.attachObserver();
    }

    void removeHierachyListener(HierarchyChangeListener listener) {
        assert (this._listener == listener);
        this.detachObserver();
        this._listener = null;
    }

    @Override
    protected void fireHierarchyChanged(HierarchyChangeEvent event) {
        if (this._listener != null) {
            switch (event.getId()) {
                case 2: {
                    this._listener.childAdded(event);
                    break;
                }
                case 3: {
                    this._listener.childRemoved(event);
                    break;
                }
                case 1: {
                    this._listener.structureChanged(event);
                }
            }
        }
    }
}

