/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.SortedTreeTableModel;

@Deprecated
public class SortedJTreeTable
extends JFastTreeTable {
    private static Icon arrowUp;
    private static Icon arrowDown;
    static final Dimension SORT_ICON_SIZE;
    protected SortedTreeTableModel sortedTreeTableModel;
    private int _curcol;
    private boolean _curascending;
    private final TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            SortedJTreeTable.this.sortByColumn(SortedJTreeTable.this._curcol, SortedJTreeTable.this._curascending);
        }
    };

    public SortedJTreeTable(SortedTreeTableModel model, int col, boolean ascending) {
        super(model);
        this.sortedTreeTableModel = model;
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = SortedJTreeTable.this.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = SortedJTreeTable.this.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() % 2 == 1 && column != -1) {
                    SortedJTreeTable.this.sortData(column, column == SortedJTreeTable.this._curcol ? !SortedJTreeTable.this._curascending : true);
                }
            }
        };
        DefaultTableCellRenderer headerRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = SortedJTreeTable.this.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                int col = SortedJTreeTable.this.convertColumnIndexToModel(column);
                this.setIcon(SortedJTreeTable.this.getColumnSortIcon(col));
                this.setText((String)value);
                this.setHorizontalTextPosition(10);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        headerRenderer.setHorizontalAlignment(0);
        JTableHeader th = this.getTableHeader();
        th.addMouseListener(listMouseListener);
        th.setDefaultRenderer(headerRenderer);
        this.sortData(col, ascending);
    }

    public SortedJTreeTable(SortedTreeTableModel model, int col) {
        this(model, col, true);
    }

    public SortedJTreeTable(SortedTreeTableModel model) {
        this(model, 0, true);
    }

    @Override
    public void setModel(TableModel model) {
        TableModel oldModel = this.getModel();
        if (oldModel instanceof SortedTreeTableModel) {
            oldModel.removeTableModelListener(this.tableModelListener);
        }
        super.setModel(model);
        if (model instanceof SortedTreeTableModel) {
            this.getModel().addTableModelListener(this.tableModelListener);
        }
    }

    protected int getSortColumn() {
        return this._curcol;
    }

    protected boolean isAscending() {
        return this._curascending;
    }

    protected Icon getColumnSortIcon(int col) {
        if (col != this._curcol) {
            return this.getUnsortedIcon();
        }
        return this._curascending ? this.getSortAscendingIcon() : this.getSortDescendingIcon();
    }

    protected Icon getUnsortedIcon() {
        return null;
    }

    protected Icon getSortAscendingIcon() {
        if (arrowUp == null) {
            arrowUp = new SortIconUp();
        }
        return arrowUp;
    }

    protected Icon getSortDescendingIcon() {
        if (arrowDown == null) {
            arrowDown = new SortIconDown();
        }
        return arrowDown;
    }

    protected void sortData(int col, boolean ascending) {
        if (this.sortByColumn(col, ascending)) {
            this._curcol = col;
            this._curascending = ascending;
            this.fireTableDataChanged();
        }
    }

    private boolean sortByColumn(int col, boolean ascending) {
        TreePath rootPath = new TreePath(this.getTree().getModel().getRoot());
        Enumeration<TreePath> expPaths = this.getTree().getExpandedDescendants(rootPath);
        if (this.sortedTreeTableModel.sortByColumn(col, ascending) && expPaths != null) {
            while (expPaths.hasMoreElements()) {
                TreePath path = expPaths.nextElement();
                this.getTree().expandPath(path);
            }
            return true;
        }
        return false;
    }

    private void fireTableDataChanged() {
        TableModel model = this.getModel();
        if (model instanceof AbstractTableModel) {
            ((AbstractTableModel)model).fireTableDataChanged();
        }
    }

    static {
        SORT_ICON_SIZE = new Dimension(9, 5);
    }

    private class SortIconUp
    implements Icon {
        private SortIconUp() {
        }

        @Override
        public int getIconHeight() {
            return SortedJTreeTable.SORT_ICON_SIZE.height;
        }

        @Override
        public int getIconWidth() {
            return SortedJTreeTable.SORT_ICON_SIZE.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x, y + 5, x + 9, y + 5);
            g.drawLine(x + 1, y + 4, x + 8, y + 4);
            g.drawLine(x + 2, y + 3, x + 7, y + 3);
            g.drawLine(x + 3, y + 2, x + 6, y + 2);
            g.drawLine(x + 4, y + 1, x + 5, y + 1);
        }
    }

    private class SortIconDown
    implements Icon {
        private SortIconDown() {
        }

        @Override
        public int getIconHeight() {
            return SortedJTreeTable.SORT_ICON_SIZE.height;
        }

        @Override
        public int getIconWidth() {
            return SortedJTreeTable.SORT_ICON_SIZE.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x, y + 1, x + 9, y + 1);
            g.drawLine(x + 1, y + 2, x + 8, y + 2);
            g.drawLine(x + 2, y + 3, x + 7, y + 3);
            g.drawLine(x + 3, y + 4, x + 6, y + 4);
            g.drawLine(x + 4, y + 5, x + 5, y + 5);
        }
    }
}

