/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.controls.SingleRowTabbedPane;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.resource.ControlsArb;
import oracle.ide.resource.IdeIcons;

public class SingleRowTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Insets _tabAreaInsets = new Insets(0, 0, 0, 0);
    private static final Insets _contentBorderInsets = new Insets(2, 0, 0, 0);
    private static final Insets _selectedTabPadInsets = new Insets(0, 0, 0, 0);
    protected static final Comparator scrollMenuItemComparator = new ScrollMenuItemComparator();
    protected static final Icon blankIcon = IdeIcons.getIcon((int)23);
    protected static final Icon scrollBothIcon = ControlsArb.getIcon(3);
    protected static final Icon scrollLeftIcon = ControlsArb.getIcon(4);
    protected static final Icon scrollRightIcon = ControlsArb.getIcon(5);
    protected static final int scrollButtonWidth = Math.max(scrollBothIcon.getIconWidth(), Math.max(scrollLeftIcon.getIconWidth(), scrollRightIcon.getIconWidth()));
    protected static final int scrollButtonHeight = Math.max(scrollBothIcon.getIconHeight(), Math.max(scrollLeftIcon.getIconHeight(), scrollRightIcon.getIconHeight()));
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected EventHandler eventHandler;
    protected JPopupMenu scrollMenu;
    protected Font scrollMenuBoldFont;
    protected ToggleAction scrollMenuSortAction;
    protected ToggleAction scrollMenuShowVisibleAction;
    protected int mouseOverIndex;
    protected int firstVisibleIndex;
    protected int lastVisibleIndex;
    protected boolean lockFirstVisible;

    private SingleRowTabbedPaneUI() {
    }

    public void showScrollMenu() {
        if (this.isScrollButtonVisible() && !this.isScrollMenuVisible()) {
            this.setScrollMenuVisible(true);
        }
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return super.tabForCoordinate(pane, x, y);
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int index) {
        return super.getTabBounds(pane, index);
    }

    public int getTabRunCount() {
        return 1;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.runCount = 1;
        this.scrollMenu = new JPopupMenu();
        this.scrollMenu.addPopupMenuListener(this.eventHandler);
        this.scrollMenuBoldFont = this.getScrollMenuBoldFont(this.scrollMenu);
        this.scrollMenuSortAction = new ScrollMenuSortAction();
        this.scrollMenuShowVisibleAction = new ScrollMenuShowVisibleAction();
        this.mouseOverIndex = -1;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.runCount = 0;
        this.scrollMenu = null;
        this.scrollMenu.removePopupMenuListener(this.eventHandler);
        this.scrollMenuSortAction = null;
        this.scrollMenuShowVisibleAction = null;
        this.mouseOverIndex = -1;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.ensureCurrentLayout();
        int tabPlacement = this.tabPane.getTabPlacement();
        int tabCount = this.tabPane.getTabCount();
        int selectedIndex = this.tabPane.getSelectedIndex();
        Rectangle clipRect = g.getClipBounds();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].intersects(clipRect)) continue;
            this.paintTab(g, tabPlacement, this.rects, i, iconRect, textRect);
        }
        if (this.isScrollButtonVisible() && this.rects[tabCount].intersects(clipRect)) {
            this.paintScrollButton(g, tabPlacement, this.rects[tabCount]);
        }
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (this.tabAreaBackground != null) {
            if (c.isOpaque()) {
                g.setColor(this.tabAreaBackground);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            this.paint(g, c);
        } else {
            super.update(g, c);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SingleRowTabbedPaneUI();
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.eventHandler = this.createEventHandler();
        if (this.eventHandler != null) {
            this.tabPane.addMouseListener(this.eventHandler);
            this.tabPane.addMouseMotionListener(this.eventHandler);
            this.tabPane.addChangeListener(this.eventHandler);
            this.tabPane.addFocusListener(this.eventHandler);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.eventHandler != null) {
            this.tabPane.removeMouseListener(this.eventHandler);
            this.tabPane.removeMouseMotionListener(this.eventHandler);
            this.tabPane.removeChangeListener(this.eventHandler);
            this.tabPane.removeFocusListener(this.eventHandler);
            this.eventHandler = null;
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.tabAreaInsets = _tabAreaInsets;
        this.contentBorderInsets = _contentBorderInsets;
        this.selectedTabPadInsets = _selectedTabPadInsets;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.tabAreaBackground = null;
        this.selectColor = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    @Override
    protected ChangeListener createChangeListener() {
        return null;
    }

    @Override
    protected FocusListener createFocusListener() {
        return null;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SingleRowTabbedPaneLayout();
    }

    @Override
    protected Icon getIconForTab(int tabIndex) {
        Icon disabledIcon;
        if ((!this.isTabEnabled(tabIndex) || tabIndex != this.tabPane.getSelectedIndex() && tabIndex != this.mouseOverIndex) && (disabledIcon = this.tabPane.getDisabledIconAt(tabIndex)) != null) {
            return disabledIcon;
        }
        return this.tabPane.getIconAt(tabIndex);
    }

    protected Icon getIconForMenu(int tabIndex) {
        Icon icon = this.tabPane.getIconAt(tabIndex);
        return icon != null ? icon : blankIcon;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        if (!this.isTabVisible(tabIndex)) {
            return;
        }
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        String title = this.tabPane.getTitleAt(tabIndex);
        title = this.layoutCompoundLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, font, metrics, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    protected void paintIcon(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        int hotkey;
        super.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        if (icon != null && (hotkey = this.getHotkeyAt(tabIndex)) != -1) {
            Rectangle iconIcon = new Rectangle();
            Rectangle iconText = new Rectangle();
            String num = Integer.toString(hotkey);
            this.layoutCompoundLabel(tabPlacement, metrics, tabIndex, num, null, iconRect, iconIcon, iconText, false);
            Color bg = this.selectColor != null ? this.selectColor : this.tabPane.getBackgroundAt(tabIndex);
            g.setColor(bg);
            if (isSelected || tabIndex == this.mouseOverIndex) {
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints oldHints = g2.getRenderingHints();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                TextLayout textLayout = new TextLayout(num, g.getFont(), g2.getFontRenderContext());
                AffineTransform transform = new AffineTransform();
                Rectangle2D bounds = textLayout.getBounds();
                transform.setToTranslation((double)iconText.x - bounds.getX() + (iconText.getWidth() - bounds.getWidth()) / 2.0, (double)iconText.y - bounds.getY() + (iconText.getHeight() - bounds.getHeight()) / 2.0);
                g2.draw(textLayout.getOutline(transform));
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                this.paintText(g, tabPlacement, font, metrics, tabIndex, num, iconText, isSelected);
                g2.setRenderingHints(oldHints);
            } else {
                this.paintText(g, tabPlacement, font, metrics, tabIndex, num, iconText, isSelected);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.selectColor != null) {
            g.setColor(this.selectColor);
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex));
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x, y, w, h - 1);
                break;
            }
            case 4: {
                g.fillRect(x, y, w, h - 1);
                break;
            }
            case 3: {
                g.fillRect(x, y, w - 1, h);
                break;
            }
            default: {
                g.fillRect(x, y, w - 1, h);
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color rightBottomColor;
        boolean isOver = tabIndex == this.mouseOverIndex;
        Color leftTopColor = isSelected ? this.shadow : this.lightHighlight;
        Color color = rightBottomColor = isSelected ? this.lightHighlight : this.shadow;
        if (isSelected || isOver) {
            g.setColor(leftTopColor);
            g.drawLine(x, y + h - 1, x, y);
            g.drawLine(x, y, x + w - 1, y);
        }
        g.setColor(rightBottomColor);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        if (isOver && !isSelected) {
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.lightHighlight);
        g.drawLine(x, y + 1, x + w - 1, y + 1);
        g.setColor(this.shadow);
        g.drawLine(x, y, x + w - 1, y);
        if (selectedIndex != -1) {
            Rectangle tabRect = this.rects[selectedIndex];
            if (this.selectColor != null) {
                g.setColor(this.selectColor);
            } else {
                g.setColor(this.tabPane.getBackgroundAt(selectedIndex));
            }
            g.drawLine(tabRect.x + 1, y, tabRect.x + tabRect.width - 2, y);
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected String layoutCompoundLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        title = SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
        return title;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        switch (tabPlacement) {
            case 1: 
            case 2: {
                return isSelected ? 1 : 0;
            }
            case 3: 
            case 4: {
                return isSelected ? 0 : -1;
            }
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        switch (tabPlacement) {
            case 1: 
            case 2: {
                return isSelected ? 1 : 0;
            }
            case 3: 
            case 4: {
                return isSelected ? 0 : -1;
            }
        }
        return 0;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        int height = super.calculateMaxTabHeight(tabPlacement);
        return Math.max(height, scrollButtonHeight);
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    protected int getHotkeyAt(int tabIndex) {
        return ((SingleRowTabbedPane)this.tabPane).getHotkeyAt(tabIndex);
    }

    protected void paintScrollButton(Graphics g, int tabPlacement, Rectangle rect) {
        Icon icon;
        int tabCount = this.tabPane.getTabCount();
        if (this.firstVisibleIndex > 0 && this.lastVisibleIndex < tabCount - 1) {
            icon = scrollBothIcon;
        } else if (this.firstVisibleIndex > 0) {
            icon = scrollLeftIcon;
        } else if (this.lastVisibleIndex < tabCount - 1) {
            icon = scrollRightIcon;
        } else {
            return;
        }
        boolean isSelected = this.isScrollMenuVisible();
        boolean isOver = this.mouseOverIndex == tabCount;
        int x = rect.x + (rect.width - icon.getIconWidth()) / 2 + this.getTabLabelShiftX(tabPlacement, tabCount, isSelected);
        int y = rect.y + (rect.height - icon.getIconHeight()) / 2 + this.getTabLabelShiftY(tabPlacement, tabCount, isSelected);
        if (isSelected || isOver) {
            this.paintTabBorder(g, tabPlacement, tabCount, rect.x, rect.y, rect.width, rect.height, isSelected);
        }
        icon.paintIcon(this.tabPane, g, x, y);
    }

    protected void setMouseOver(int tabIndex) {
        if (this.mouseOverIndex != tabIndex) {
            int tabPlacement = this.tabPane.getTabPlacement();
            if (this.mouseOverIndex != -1) {
                this.repaintTab(this.mouseOverIndex);
            }
            this.mouseOverIndex = tabIndex;
            if (tabIndex != -1) {
                this.repaintTab(tabIndex);
            }
        }
    }

    protected void repaintTab(int tabIndex) {
        if (tabIndex >= 0 && tabIndex < this.rects.length) {
            this.tabPane.repaint(this.rects[tabIndex]);
        }
    }

    protected boolean isTabEnabled(int tabIndex) {
        return this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex);
    }

    protected boolean isTabVisible(int tabIndex) {
        return tabIndex >= 0 && tabIndex < this.tabPane.getTabCount() && this.rects[tabIndex].width != 0;
    }

    protected boolean isInScrollButton(int x, int y) {
        if (!this.isScrollButtonVisible()) {
            return false;
        }
        int tabCount = this.tabPane.getTabCount();
        return this.rects[tabCount].contains(x, y);
    }

    protected boolean isScrollButtonVisible() {
        if (this.firstVisibleIndex > 0) {
            return true;
        }
        int tabCount = this.tabPane.getTabCount();
        return this.lastVisibleIndex < tabCount - 1;
    }

    protected boolean isScrollMenuSorted() {
        return this.scrollMenuSortAction.getState();
    }

    protected void setScrollMenuSorted(boolean sorted) {
        this.scrollMenuSortAction.setState(sorted);
    }

    protected boolean isScrollMenuShowVisible() {
        return this.scrollMenuShowVisibleAction.getState();
    }

    protected void setScrollMenuShowVisible(boolean showVisible) {
        this.scrollMenuShowVisibleAction.setState(showVisible);
    }

    protected boolean isScrollMenuVisible() {
        return this.scrollMenu.isVisible();
    }

    protected void setScrollMenuVisible(boolean visible) {
        if (visible == this.isScrollMenuVisible()) {
            return;
        }
        int tabCount = this.tabPane.getTabCount();
        this.repaintTab(tabCount);
        if (visible) {
            int y;
            int x;
            this.scrollMenu.removeAll();
            boolean showVisible = this.isScrollMenuShowVisible();
            boolean sortMenu = this.isScrollMenuSorted();
            ArrayList<JComponent> menuItems = new ArrayList<JComponent>(tabCount);
            for (int i = 0; i < tabCount; ++i) {
                if (showVisible || !this.isTabVisible(i)) {
                    menuItems.add(this.createScrollMenuItem(i));
                }
                if (sortMenu || showVisible || i != this.firstVisibleIndex || this.firstVisibleIndex <= 0 || this.lastVisibleIndex >= tabCount - 1) continue;
                menuItems.add(new JSeparator());
            }
            if (sortMenu) {
                Collections.sort(menuItems, scrollMenuItemComparator);
            }
            for (Object e : menuItems) {
                if (e instanceof JMenuItem) {
                    this.scrollMenu.add((JMenuItem)e);
                    continue;
                }
                this.scrollMenu.addSeparator();
            }
            this.scrollMenu.addSeparator();
            this.scrollMenu.add(new ToggleMenuItem(this.scrollMenuSortAction));
            Rectangle buttonBounds = this.rects[tabCount];
            Dimension dimension = this.scrollMenu.getPreferredSize();
            int buttonRight = buttonBounds.x + buttonBounds.width - 1;
            int buttonBottom = buttonBounds.y + buttonBounds.height - 1;
            switch (this.tabPane.getTabPlacement()) {
                case 2: {
                    x = buttonRight;
                    y = buttonBottom - dimension.height;
                    break;
                }
                case 4: {
                    x = buttonBounds.x - dimension.width;
                    y = buttonBottom - dimension.height;
                    break;
                }
                case 3: {
                    x = buttonRight - dimension.width;
                    y = buttonBounds.y - dimension.height;
                    break;
                }
                default: {
                    x = buttonRight - dimension.width;
                    y = buttonBottom;
                }
            }
            MenuUtils.showPopupMenu((JPopupMenu)this.scrollMenu, (Component)this.tabPane, (int)x, (int)y);
        } else {
            this.scrollMenu.setVisible(false);
        }
    }

    protected JMenuItem createScrollMenuItem(int tabIndex) {
        String title = this.tabPane.getTitleAt(tabIndex);
        Icon icon = this.getIconForMenu(tabIndex);
        JMenuItem item = new JMenuItem(title, icon);
        if (this.isTabVisible(tabIndex)) {
            item.setFont(this.scrollMenuBoldFont);
        }
        item.setActionCommand(Integer.toString(tabIndex));
        item.addActionListener(this.eventHandler);
        return item;
    }

    protected Font getScrollMenuBoldFont(Component component) {
        Font font = component.getFont();
        component.setFont(font.deriveFont(0));
        return font.deriveFont(1);
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected static class ScrollMenuItemComparator
    implements Comparator {
        protected ScrollMenuItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            JMenuItem item1 = (JMenuItem)o1;
            JMenuItem item2 = (JMenuItem)o2;
            return item1.getText().compareToIgnoreCase(item2.getText());
        }
    }

    protected static class ScrollMenuAction
    extends ToggleAction {
        private String propertyName;

        public ScrollMenuAction(String name, String propertyName) {
            super(name, null);
            this.propertyName = propertyName;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.setState(!this.getState());
            if (this.propertyName != null) {
                JMenuItem item = (JMenuItem)event.getSource();
                JPopupMenu scrollMenu = (JPopupMenu)item.getParent();
                JComponent tabPane = (JComponent)scrollMenu.getInvoker();
                boolean newValue = this.getState();
                boolean oldValue = !newValue;
                tabPane.firePropertyChange(this.propertyName, oldValue, newValue);
            }
        }

        @Override
        public Object getValue(String key) {
            Object o = super.getValue(key);
            if (o == null && key == "SmallIcon") {
                return blankIcon;
            }
            return o;
        }
    }

    protected static class ScrollMenuShowVisibleAction
    extends ScrollMenuAction {
        public ScrollMenuShowVisibleAction() {
            super(ControlsArb.getString(7), "scrollMenuShowVisible");
        }
    }

    protected static class ScrollMenuSortAction
    extends ScrollMenuAction {
        public ScrollMenuSortAction() {
            super(ControlsArb.getString(6), "scrollMenuSorted");
        }
    }

    protected class EventHandler
    implements MouseListener,
    MouseMotionListener,
    ChangeListener,
    FocusListener,
    PopupMenuListener,
    ActionListener {
        protected EventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            if (!tabPane.isEnabled()) {
                SingleRowTabbedPaneUI.this.setMouseOver(-1);
                return;
            }
            int tabIndex = SingleRowTabbedPaneUI.this.tabForCoordinate(tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && tabPane.isEnabledAt(tabIndex)) {
                SingleRowTabbedPaneUI.this.setMouseOver(tabIndex);
            } else if (SingleRowTabbedPaneUI.this.isInScrollButton(e.getX(), e.getY())) {
                SingleRowTabbedPaneUI.this.setMouseOver(tabPane.getTabCount());
            } else {
                SingleRowTabbedPaneUI.this.setMouseOver(-1);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SingleRowTabbedPaneUI.this.setMouseOver(-1);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SingleRowTabbedPaneUI.this.isInScrollButton(e.getX(), e.getY())) {
                SingleRowTabbedPaneUI.this.setScrollMenuVisible(!SingleRowTabbedPaneUI.this.isScrollMenuVisible());
            } else {
                SingleRowTabbedPaneUI.this.setScrollMenuVisible(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseEntered(e);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int selectedIndex = tabPane.getSelectedIndex();
            if (selectedIndex < SingleRowTabbedPaneUI.this.firstVisibleIndex || selectedIndex > SingleRowTabbedPaneUI.this.lastVisibleIndex) {
                SingleRowTabbedPaneUI.this.lockFirstVisible = false;
                tabPane.revalidate();
            } else {
                SingleRowTabbedPaneUI.this.lockFirstVisible = true;
                SingleRowTabbedPaneUI.this.setVisibleComponent(tabPane.getComponentAt(selectedIndex));
            }
            tabPane.repaint();
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            SingleRowTabbedPaneUI.this.repaintTab(tabPane.getSelectedIndex());
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            SingleRowTabbedPaneUI.this.repaintTab(tabPane.getSelectedIndex());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SingleRowTabbedPaneUI.this.repaintTab(SingleRowTabbedPaneUI.this.tabPane.getTabCount());
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            int index = Integer.parseInt(command);
            SingleRowTabbedPaneUI.this.tabPane.setSelectedIndex(index);
        }
    }

    protected class SingleRowTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected SingleRowTabbedPaneLayout() {
            super(SingleRowTabbedPaneUI.this);
        }

        @Override
        public void calculateLayoutInfo() {
            int tabCount = SingleRowTabbedPaneUI.this.tabPane.getTabCount();
            SingleRowTabbedPaneUI.this.assureRectsCreated(tabCount + 1);
            this.calculateTabRects(SingleRowTabbedPaneUI.this.tabPane.getTabPlacement(), tabCount);
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = SingleRowTabbedPaneUI.this.getFontMetrics();
            int fontHeight = metrics.getHeight();
            Insets insets = SingleRowTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = SingleRowTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension size = SingleRowTabbedPaneUI.this.tabPane.getSize();
            int selectedIndex = SingleRowTabbedPaneUI.this.tabPane.getSelectedIndex();
            SingleRowTabbedPaneUI.this.maxTabHeight = SingleRowTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            SingleRowTabbedPaneUI.this.maxTabWidth = 0;
            int x = insets.left + tabAreaInsets.left;
            int y = insets.top + tabAreaInsets.top;
            int returnAt = size.width - (insets.right + tabAreaInsets.right);
            if (SingleRowTabbedPaneUI.this.lockFirstVisible) {
                SingleRowTabbedPaneUI.this.lastVisibleIndex = SingleRowTabbedPaneUI.this.firstVisibleIndex;
            } else {
                SingleRowTabbedPaneUI.this.lockFirstVisible = true;
                SingleRowTabbedPaneUI.this.lastVisibleIndex = 0;
                SingleRowTabbedPaneUI.this.firstVisibleIndex = 0;
            }
            int i = SingleRowTabbedPaneUI.this.firstVisibleIndex;
            while (i < tabCount) {
                int xMax;
                int w = SingleRowTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                if (x + w > (xMax = returnAt - (SingleRowTabbedPaneUI.this.firstVisibleIndex > 0 || i < tabCount - 1 ? scrollButtonWidth : 0))) {
                    int j;
                    if (i > selectedIndex) {
                        for (int j2 = i; j2 < tabCount; ++j2) {
                            ((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this).rects[j2].width = 0;
                        }
                        break;
                    }
                    int overshoot = x + w - xMax;
                    int shift = 0;
                    for (j = 0; j < i; ++j) {
                        ((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this).rects[j].width = 0;
                        if ((shift += ((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this).rects[j].width) >= overshoot) break;
                    }
                    if (shift != 0) {
                        SingleRowTabbedPaneUI.this.firstVisibleIndex = ++j;
                        while (j < i) {
                            ((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this).rects[j++].x -= shift;
                        }
                        x -= shift;
                    }
                }
                Rectangle r = SingleRowTabbedPaneUI.this.rects[i];
                r.width = Math.min(w, xMax - x - insets.left - tabAreaInsets.left);
                r.height = SingleRowTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                r.x = x;
                r.y = y - (r.height - SingleRowTabbedPaneUI.this.maxTabHeight);
                SingleRowTabbedPaneUI.this.maxTabWidth = Math.max(SingleRowTabbedPaneUI.this.maxTabWidth, w);
                x += r.width;
                SingleRowTabbedPaneUI.this.lastVisibleIndex = i++;
            }
            if (SingleRowTabbedPaneUI.this.firstVisibleIndex > 0 || SingleRowTabbedPaneUI.this.lastVisibleIndex < tabCount - 1) {
                Rectangle r = SingleRowTabbedPaneUI.this.rects[tabCount];
                r.x = returnAt - scrollButtonWidth;
                r.y = y;
                r.width = scrollButtonWidth;
                r.height = SingleRowTabbedPaneUI.this.maxTabHeight;
                SingleRowTabbedPaneUI.this.repaintTab(tabCount);
            } else {
                ((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this).rects[tabCount].width = 0;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
        }
    }
}

