/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.nulls.NullIcon;
import oracle.javatools.controls.PropertyChangeAdapter;
import oracle.javatools.util.PlatformUtils;

public class RadioMenuItem
extends JRadioButtonMenuItem {
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;

    public RadioMenuItem(ToggleAction action) {
        super(action);
        this.setSelected(action.getState());
        action.listenForItemEvent(this);
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        Integer i;
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(a != null ? (String)a.getValue("Name") : null);
        this.setEnabled(a != null ? a.isEnabled() : true);
        if (a != null && (i = (Integer)a.getValue("MnemonicKey")) != null) {
            this.setMnemonic(i);
        }
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new InnerPropertyChangeAdaptor(this, a);
    }

    @Override
    public Icon getIcon() {
        if (!this.checkedForIcon) {
            Action a = this.getAction();
            Icon icon = null;
            if (a != null) {
                this.checkedForIcon = true;
                icon = (Icon)a.getValue("SmallIcon");
                if (icon == null && PlatformUtils.isMac() && this.getParent() instanceof JPopupMenu && ((JPopupMenu)this.getParent()).getInvoker() instanceof JMenu) {
                    icon = new NullIcon();
                }
                this.setIcon(icon);
            }
        }
        return super.getIcon();
    }

    @Override
    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    @Override
    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    @Override
    public Icon getDisabledIcon() {
        Action a;
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon && (a = this.getAction()) != null) {
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)a.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    public static Icon getRadioButtonMenuItemIcon() {
        return UIManager.getIcon("RadioButtonMenuItem.checkIcon");
    }

    @Override
    public MenuElement[] getSubElements() {
        return MenuItem.EMPTY_MENU_ELEMENTS;
    }

    private static class InnerPropertyChangeAdaptor
    extends PropertyChangeAdapter {
        public InnerPropertyChangeAdaptor(AbstractButton adaptee, Action action) {
            super(adaptee, action);
        }

        protected void stateChanged(PropertyChangeEvent e) {
            final RadioMenuItem adaptee = (RadioMenuItem)this.getAdaptee();
            final Boolean toggledState = (Boolean)e.getNewValue();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (adaptee.isSelected() != toggledState.booleanValue()) {
                        adaptee.setSelected(toggledState);
                    }
                }
            };
            runnable.run();
        }
    }
}

