/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.swing.Timer;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.javatools.jndi.Names;
import org.netbeans.api.progress.ProgressHandle;

public final class ProgressTrackerControl2
implements ProgressTracker,
ActionListener {
    private static final String PROGRESS_TRACKER_NAME = "ide/progressTracker";
    private List<TaskRecord> taskList;
    private Timer timer;

    public ProgressTrackerControl2() {
        Names.bind((Context)Names.newInitialContext(), (String)PROGRESS_TRACKER_NAME, (Object)this);
        this.taskList = new ArrayList<TaskRecord>();
    }

    @Override
    public void addTask(ProgressTrackedTask task) {
        this.addTask(task, null);
    }

    @Override
    public void addTask(ProgressTrackedTask task, String threadName) {
        TaskRecord taskData = new TaskRecord(task, threadName);
        this.taskList.add(taskData);
        if (this.timer == null) {
            this.timer = new Timer(200, this);
            this.timer.start();
        }
        taskData.getThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        List<TaskRecord> list = this.taskList;
        synchronized (list) {
            ArrayList<TaskRecord> list2 = new ArrayList<TaskRecord>(this.taskList);
            for (TaskRecord d : list2) {
                d.getHandle().progress(d.getTask().getCurrentValue());
                if (d.getThread().isAlive()) continue;
                d.getHandle().finish();
                this.taskList.remove(d);
            }
            if (this.taskList.isEmpty() && this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread getThread(ProgressTrackedTask task) {
        Thread thread = null;
        List<TaskRecord> list = this.taskList;
        synchronized (list) {
            for (TaskRecord taskData : this.taskList) {
                if (taskData.getTask() != task) continue;
                thread = taskData.getThread();
                break;
            }
        }
        return thread;
    }

    private static final class TaskRecord {
        private final ProgressTrackedTask task;
        private final Thread thread;
        private final ProgressHandle handle;

        public TaskRecord(ProgressTrackedTask progressTrackedTask, String threadName) {
            this.task = progressTrackedTask;
            this.thread = new Thread(this.task);
            if (threadName == null) {
                this.thread.setName(this.task.getTaskDescription());
            } else {
                this.thread.setName(threadName);
            }
            this.handle = ProgressHandle.createHandle((String)this.task.getCurrentText());
            this.handle.start(this.task.getMinimum());
            if (this.task.isIndeterminate()) {
                this.handle.switchToIndeterminate();
            } else {
                this.handle.switchToDeterminate(this.task.getMaximum());
            }
        }

        public ProgressHandle getHandle() {
            return this.handle;
        }

        public ProgressTrackedTask getTask() {
            return this.task;
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

