/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Dimension;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.ThinBevel;

public class JToolButton
extends JButton {
    public static final Dimension DEFAULT_SIZE = new Dimension(28, 25);
    private Border _lowered = ThinBevel.LOWERED_BORDER;
    private Border _raised = ThinBevel.RAISED_BORDER;

    public JToolButton() {
        this((Icon)null);
    }

    public JToolButton(Icon icon) {
        this(icon, false);
    }

    public JToolButton(Icon icon, boolean hasRolloverBorder) {
        this(icon, hasRolloverBorder, null);
    }

    public JToolButton(Icon icon, boolean hasRolloverBorder, Dimension dim) {
        this.setContentAreaFilled(false);
        this.setDefaultCapable(false);
        if (icon != null) {
            this.setIcon(icon);
        }
        ChangeListener listener = this.getChangeListener(hasRolloverBorder);
        ButtonModel buttonModel = this.getModel();
        buttonModel.addChangeListener(listener);
        this.setFixedSize(dim != null ? dim : DEFAULT_SIZE);
        this.setRolloverEnabled(hasRolloverBorder);
        this.setBorder(hasRolloverBorder ? null : this.getRaisedBorder());
    }

    public void setFixedSize(Dimension dim) {
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    public Border getLoweredBorder() {
        return this._lowered;
    }

    public void setLoweredBorder(Border loweredBorder) {
        this._lowered = loweredBorder;
    }

    public Border getRaisedBorder() {
        return this._raised;
    }

    public void setRaisedBorder(Border raisedBorder) {
        this._raised = raisedBorder;
    }

    protected ChangeListener getChangeListener(boolean hasRolloverBorder) {
        return new L(hasRolloverBorder);
    }

    protected class L
    implements ChangeListener {
        private final boolean _hasRolloverBorder;

        public L(boolean hasRolloverBorder) {
            this._hasRolloverBorder = hasRolloverBorder;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            boolean isRaised;
            ButtonModel buttonModel = (ButtonModel)e.getSource();
            boolean isLowered = buttonModel.isArmed() && buttonModel.isPressed();
            boolean bl = isRaised = !isLowered && (!this._hasRolloverBorder || buttonModel.isRollover());
            JToolButton.this.setBorder(isLowered ? JToolButton.this.getLoweredBorder() : (isRaised ? JToolButton.this.getRaisedBorder() : null));
        }
    }
}

