/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;

public class JTabbedPane2
extends JTabbedPane {
    private static final Color CLR_HIGHLIGHT = new Color(255, 144, 25);

    public JTabbedPane2() {
    }

    public JTabbedPane2(int tabPlacement) {
        super(tabPlacement);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (JDK.HAS_BUG_4502288 && e.getID() == 501) {
            final int oldSelected = this.getSelectedIndex();
            super.processMouseEvent(e);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int newSelected = JTabbedPane2.this.getSelectedIndex();
                    if (oldSelected != newSelected && !GraphicsUtils.isAncestorOfFocusedComponent((Component)JTabbedPane2.this)) {
                        Component selectedComponent = JTabbedPane2.this.getComponentAt(newSelected);
                        GraphicsUtils.focusComponentOrChild((Component)selectedComponent, (boolean)true);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (JDK.HAS_BUG_TABBEDPANE_NPE_JAWS && event == null) {
            return this.getToolTipText();
        }
        return super.getToolTipText(event);
    }

    public void highlight(int index, boolean highlight) {
        Color newColor = highlight ? CLR_HIGHLIGHT : null;
        this.setBackgroundAt(index, newColor);
    }
}

