/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.controls.InterceptLookupTable;

public final class ForegroundSwappedIcon
extends ImageIcon {
    private final Icon _baseIcon;
    private Color _foregroundColor;
    private final boolean _imageCreated = false;

    public ForegroundSwappedIcon(Icon baseIcon, Color foregroundColor) {
        this._baseIcon = baseIcon;
        this._foregroundColor = foregroundColor;
    }

    public Icon getBaseIcon() {
        return this._baseIcon;
    }

    @Override
    public int getIconHeight() {
        return this._baseIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this._baseIcon.getIconWidth();
    }

    @Override
    public Image getImage() {
        BufferedImage bi = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = bi.createGraphics();
        this._baseIcon.paintIcon(null, g, 0, 0);
        if (this._foregroundColor != null) {
            InterceptLookupTable interceptLookupTable = new InterceptLookupTable();
            int[] destForeground = new int[]{this._foregroundColor.getRed(), this._foregroundColor.getGreen(), this._foregroundColor.getBlue(), this._foregroundColor.getAlpha()};
            interceptLookupTable.add(new int[]{0, 0, 0, 255}, destForeground);
            LookupOp lookupOp = new LookupOp(interceptLookupTable, null);
            bi = lookupOp.filter(bi, null);
        }
        g.dispose();
        this.setImage(bi);
        return super.getImage();
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.getImage();
        super.paintIcon(c, g, x, y);
    }
}

