/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.LazyLoadedTraversable;
import oracle.ide.panels.Traversable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class ExtensionSettingsPage
extends HashStructureAdapter {
    private ExtensionSettingsPage(HashStructure hs) {
        super(hs);
    }

    static ExtensionSettingsPage getInstance(HashStructure hs) {
        return new ExtensionSettingsPage(hs);
    }

    public String getIdPath() {
        String parentId = this.getParentId();
        String id = this.getId();
        StringBuffer result = new StringBuffer(2 + parentId.length() + id.length());
        if (parentId.charAt(0) != '/') {
            result.append('/');
        }
        result.append(parentId);
        result.append('/');
        result.append(id);
        return result.toString();
    }

    public String getSearchTags() {
        return this._hash.getString("search-tags", "");
    }

    public String getId() {
        return this._hash.getString("id");
    }

    public boolean includeInDefault() {
        return this._hash.getBoolean("include-in-default", true);
    }

    public String getParentId() {
        String parent = this._hash.getString("parent-idref");
        if (parent == null) {
            parent = this._hash.getString("parent-refid");
        }
        return parent;
    }

    public String getLabel() {
        return this._hash.getString("label/#text");
    }

    public String getToolTip() {
        return this._hash.getString("tooltip/#text");
    }

    public MetaClass getTraversableClass() {
        LazyClassAdapter adapter = LazyClassAdapter.getInstance(this._hash);
        return adapter.getMetaClass("traversable-class/#text");
    }

    public Traversable newTraversable() {
        String extensionId;
        LazyClassAdapter adapter = LazyClassAdapter.getInstance(this._hash);
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        if (registry.isFullyLoaded(extensionId = HashStructureHook.getExtensionId(this.getHashStructure())) || SettingsUIRegistry.getCustomizations().shouldForceLoadPages()) {
            return adapter.createInstance(Traversable.class, "traversable-class/#text");
        }
        return new LazyLoadedTraversable(adapter.getMetaClass("traversable-class/#text"), extensionId);
    }

    public String getTraversableClassAsString() {
        return this._hash.getString("traversable-class/#text");
    }

    public Collection<String> getFieldIds() {
        List fields = this._hash.getAsList("fields/field");
        if (fields == null) {
            return Collections.emptySet();
        }
        ArrayList<String> results = new ArrayList<String>(fields.size());
        for (HashStructure hs : fields) {
            results.add(hs.getString("id"));
        }
        return Collections.unmodifiableList(results);
    }
}

