/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.controls.ButtonsLayoutManager;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;

public class CheckBoxListPanel
extends JPanel
implements ActionListener {
    private CheckBoxList _list;
    private CheckBoxListModel _listModel;
    private JScrollPane _scrollPane = new JScrollPane();
    private JButton _selectAllBtn = new JButton();
    private JButton _deselectAllBtn = new JButton();
    private ArrayList _buttonList = new ArrayList();
    private JPanel _buttonPanel;

    public CheckBoxListPanel(CheckBoxListModel listModel) {
        this._listModel = listModel;
        this._list = new CheckBoxList(this._listModel);
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._selectAllBtn, (String)ComponentArb.getString(46));
        ResourceUtils.resButton((AbstractButton)this._deselectAllBtn, (String)ComponentArb.getString(47));
        this._selectAllBtn.addActionListener(this);
        this._deselectAllBtn.addActionListener(this);
        this._buttonList.add(this._deselectAllBtn);
        this._buttonList.add(this._selectAllBtn);
        ButtonsLayoutManager buttonManager = new ButtonsLayoutManager();
        buttonManager.setGap(5);
        this._buttonPanel = new JPanel(buttonManager);
        this.layoutButtons();
        this._scrollPane.getViewport().setView((Component)this._list);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._buttonPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public CheckBoxList getList() {
        return this._list;
    }

    public void layoutButtons() {
        int numButtons = this._buttonList.size();
        for (int i = 0; i < numButtons; ++i) {
            this._buttonPanel.add((Component)((JButton)this._buttonList.get(i)), (Object)i);
        }
    }

    public void addButton(JButton button) {
        this._buttonList.add(button);
    }

    public JButton getSelectAllButton() {
        return this._selectAllBtn;
    }

    public JButton getDeselectAllButton() {
        return this._deselectAllBtn;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._selectAllBtn) {
            CheckBoxListModel listModel = this._list.getCheckBoxListModel();
            listModel.selectAll();
            this._list.repaint();
        } else if (event.getSource() == this._deselectAllBtn) {
            CheckBoxListModel listModel = this._list.getCheckBoxListModel();
            listModel.deselectAll();
            this._list.repaint();
        }
    }
}

