/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.compiler;

import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.PostBuilder;

public class CompileArguments {
    private Context context;
    private boolean rebuildAllSources;
    private boolean saveBeforeCompiling;
    private boolean waitForTermination = true;
    private boolean compileDependencies = true;
    private OutputStream outputStream;
    private OutputStream diagnosticsStream;
    private PostBuilder postBuilder;
    private Boolean clearLogBeforeCompile;
    private Map<String, String> javaCompilerOptions;
    private boolean forceRebuildOnProjectChanges = true;
    private Boolean quiet;
    private boolean throwOnConcurrentCleanOrCompile;
    private boolean waitOnConcurrentCleanOrCompile;
    private boolean noCleanBeforeRebuild;

    public CompileArguments(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Need a valid context for compilations");
        }
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isRebuildAllSources() {
        return this.rebuildAllSources;
    }

    public void setRebuildAllSources(boolean rebuildAllSources) {
        this.rebuildAllSources = rebuildAllSources;
    }

    public boolean isSaveBeforeCompiling() {
        return this.saveBeforeCompiling;
    }

    public void setSaveBeforeCompiling(boolean saveBeforeCompiling) {
        this.saveBeforeCompiling = saveBeforeCompiling;
    }

    public boolean isWaitForTermination() {
        return this.waitForTermination;
    }

    public void setWaitForTermination(boolean waitForTermination) {
        this.waitForTermination = waitForTermination;
    }

    @Deprecated
    public boolean isCompileDependentProjects() {
        return this.compileDependencies;
    }

    public boolean isCompileDependencies() {
        return this.compileDependencies;
    }

    @Deprecated
    public void setCompileDepdendentProjects(boolean compileDependencies) {
        this.compileDependencies = compileDependencies;
    }

    public void setCompileDependencies(boolean compileDependencies) {
        this.compileDependencies = compileDependencies;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getDiagnosticsStream() {
        return this.diagnosticsStream;
    }

    public void setDiagnosticsStream(OutputStream diagnosticsStream) {
        this.diagnosticsStream = diagnosticsStream;
    }

    public PostBuilder getPostBuilder() {
        return this.postBuilder;
    }

    public void setPostBuilder(PostBuilder postBuilder) {
        this.postBuilder = postBuilder;
    }

    @Deprecated
    public boolean getClearLogBeforeCompile() {
        return this.isClearLogBeforeCompile();
    }

    public boolean isClearLogBeforeCompile() {
        if (this.clearLogBeforeCompile == null) {
            return Ide.getEnvironOptions().getClearCompilerLogBeforeCompile();
        }
        return this.clearLogBeforeCompile;
    }

    public void setClearLogBeforeCompile(boolean clearLogBeforeCompile) {
        this.clearLogBeforeCompile = clearLogBeforeCompile;
    }

    public void addJavaCompilerOption(String option, String argument) {
        if (option == null) {
            throw new IllegalArgumentException("Invalid option");
        }
        if (this.javaCompilerOptions == null) {
            this.javaCompilerOptions = new LinkedHashMap<String, String>();
        }
        this.javaCompilerOptions.put(option, argument);
    }

    public Map<String, String> getJavaCompilerOptions() {
        return this.javaCompilerOptions == null ? Collections.emptyMap() : this.javaCompilerOptions;
    }

    public void addJavaCompilerOptions(String options) {
        if (options == null) {
            return;
        }
        int index = 0;
        while (index < options.length()) {
            char c;
            if ((c = options.charAt(index++)) == '\\' && index < options.length() && options.charAt(index) == ',') {
                ++index;
                continue;
            }
            if (c != ',') continue;
            String option = options.substring(0, index - 1).replace("\\,", ",").trim();
            if (option.length() > 0) {
                this.addJavaCompilerOption(option, null);
            }
            options = options.substring(index);
            index = 0;
        }
        String lastOption = options.substring(0, index).replace("\\,", ",").trim();
        if (lastOption.length() > 0) {
            this.addJavaCompilerOption(lastOption, null);
        }
    }

    public void setForceRebuildOnProjectChanges(boolean forceRebuildOnProjectChanges) {
        this.forceRebuildOnProjectChanges = forceRebuildOnProjectChanges;
    }

    public boolean isForceRebuildOnProjectChanges() {
        return this.forceRebuildOnProjectChanges;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        if (this.quiet == null) {
            return !Ide.getEnvironOptions().getShowCompileProgress();
        }
        return this.quiet;
    }

    public void setThrowOnConcurrentCleanOrCompile(boolean throwOnConcurrentCleanOrCompile) {
        this.throwOnConcurrentCleanOrCompile = throwOnConcurrentCleanOrCompile;
    }

    public boolean isThrowOnConcurrentCleanOrCompile() {
        return this.throwOnConcurrentCleanOrCompile;
    }

    public void setWaitOnConcurrentCleanOrCompile(boolean waitOnConcurrentCleanOrCompile) {
        this.waitOnConcurrentCleanOrCompile = waitOnConcurrentCleanOrCompile;
    }

    public boolean isWaitOnConcurrentCleanOrCompile() {
        return this.waitOnConcurrentCleanOrCompile;
    }

    public void setNoCleanBeforeRebuild(boolean noCleanBeforeRebuild) {
        this.noCleanBeforeRebuild = noCleanBeforeRebuild;
    }

    public boolean isNoCleanBeforeRebuild() {
        return this.noCleanBeforeRebuild;
    }
}

