/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.em_cm.CmWindow;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccess;

public class CmAddin
implements DockableFactory,
Addin {
    private static SController _controllerInstance;
    private static CmAddin _addinInstance;
    static final String VIEW_TYPE = "CM_VIEW_TYPE";
    private static CmWindow _cmWindow;
    private static final int VIEW_CM_ACTION;
    private static ChangePlanAccess cpAccess;
    private final List<ChangeListener> _changeListeners = new ArrayList<ChangeListener>();
    public static final String encoding = "UTF-8";

    private CmAddin() {
    }

    public static synchronized CmAddin getInstance() {
        if (_addinInstance == null) {
            _addinInstance = new CmAddin();
        }
        return _addinInstance;
    }

    public void initialize() {
        try {
            EditorManager.getEditorManager().addEditorListener((EditorListener)new EditorL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void install() {
        if (RaptorExtensionConstants.isStandAlone()) {
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition(1);
            DockStation dockStation = DockStation.getDockStation();
            CmWindow cmWindow = CmAddin.getCmWindow();
            dockStation.dock((Dockable)cmWindow, dockingParam);
            CmAddin.getCmWindow().setDockableVisible(false);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return CmAddin.getCmWindow();
    }

    public static ChangePlanAccess getCpAccess() {
        return cpAccess;
    }

    public static CmWindow getCmWindow() {
        if (_cmWindow == null) {
            _cmWindow = new CmWindow();
        }
        return _cmWindow;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.remove(changeListener);
    }

    public void fireChangeEvent() {
        ChangeListener[] changeListenerArray = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()]);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            ChangeListener changeListener = changeListenerArray[i];
            try {
                changeListener.stateChanged(changeEvent);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        VIEW_CM_ACTION = Ide.findOrCreateCmdID((String)"cm_view");
        cpAccess = new ChangePlanAccess();
    }

    private class EditorL
    implements EditorListener {
        private EditorL() {
        }

        public void editorOpened(Editor editor) {
        }

        public void editorActivated(Editor editor) {
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    }

    public static class SController
    implements Controller {
        private SController() {
        }

        public static synchronized SController getInstance() {
            if (_controllerInstance == null) {
                _controllerInstance = new SController();
            }
            return _controllerInstance;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return ideAction.getCommandId() == VIEW_CM_ACTION;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() != VIEW_CM_ACTION) {
                return false;
            }
            DockUtil.showDockableWindow((DockableView)CmAddin.getCmWindow());
            return true;
        }
    }
}

