/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.security;

import oracle.dbtools.plugin.api.security.AuthorizationError;

public class NotAuthorizedException
extends RuntimeException {
    private final AuthorizationError error;
    private final String authorizationConstraint;
    private static final long serialVersionUID = -7587679372696218178L;

    public NotAuthorizedException(String authorizationConstraintName, AuthorizationError error, Throwable cause) {
        super(cause);
        if (authorizationConstraintName == null) {
            throw new NullPointerException();
        }
        this.authorizationConstraint = authorizationConstraintName;
        this.error = error;
    }

    public NotAuthorizedException(String authorizationConstaintName) {
        this(authorizationConstaintName, null, null);
    }

    public AuthorizationError error() {
        return this.error;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NotAuthorizedException [authConstraint=");
        builder.append(this.authorizationConstraint);
        builder.append(", error=");
        builder.append(this.error);
        builder.append("]");
        return builder.toString();
    }
}

