/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.extcache;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;

public final class ExtensionsFS
extends MultiFileSystem {
    private static final LayerCacheManager manager = LayerCacheManager.create((String)"all-extensions.dat");
    private static ExtensionsFS INSTANCE;
    static final Logger LOG;
    private boolean cacheLoaded;

    public ExtensionsFS() {
        LOG.fine("Creating extensions filesystem");
        this.setPropagateMasks(true);
        try {
            FileSystem fs = manager.loadCache();
            if (fs != null) {
                LOG.fine("Extension cache loaded");
                this.setDelegates(new FileSystem[]{fs});
                this.cacheLoaded = true;
                return;
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Cannot read cache", ex);
        }
    }

    static synchronized ExtensionsFS getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExtensionsFS();
        }
        return INSTANCE;
    }

    boolean isCacheLoaded() {
        return this.cacheLoaded;
    }

    void init(List<URL> urls) {
        LOG.fine("Storing layers");
        try {
            FileSystem fs = this.getDelegates().length == 0 ? manager.createEmptyFileSystem() : this.getDelegates()[0];
            fs = manager.store(fs, urls);
            this.setDelegates(new FileSystem[]{fs});
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Cannot save cache", ex);
        }
        LOG.fine("Storing layers done");
    }

    FileSystem getDelegate() {
        return this.getDelegates()[0];
    }

    static {
        LOG = Logger.getLogger(ExtensionsFS.class.getPackage().getName());
    }
}

