/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlmonitor.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.sqlmonitor.SqlMonitorArb;
import oracle.dbtools.sqlmonitor.editor.SqlMonitorController;
import oracle.dbtools.sqlmonitor.nodes.SqlMonitorEditorNode;
import oracle.dbtools.sqlmonitor.panels.DetailTreePanel;
import oracle.dbtools.sqlmonitor.panels.ListPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class SqlMonitorEditor
extends Editor
implements Controller,
IDBEditor {
    private Toolbar _toolbar = new Toolbar();
    private JPanel _panel = new JPanel();
    private JPanel _ui = new JPanel();
    private JComboBox _timerInterval;
    private Timer _timer;
    private TimerTask _tt;
    boolean _listUI = true;
    SqlMonitorEditor editor = this;
    public String _sqlId;
    public int _sessionId;
    public int _sessionSerial;
    private Connection _conn;
    AbstractAction back = null;
    private ListPanel _list;
    private DetailTreePanel _detailPanel;
    private IdeAction _saveAction;

    public SqlMonitorEditor() {
        this._panel.setLayout(new BorderLayout());
        this.buildToolbar();
        this._panel.add((Component)this._toolbar, "First");
        this._ui.setLayout(new GridBagLayout());
        this._panel.add(this._ui);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_monitorsql_html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionOK(Connection connection) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            callableStatement = connection.prepareCall("select '1' from dual");
            resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private void buildToolbar() {
        AbstractAction abstractAction = new AbstractAction(SqlMonitorArb.getString("REFRESH"), SqlMonitorArb.getIcon("REFRESH_ICON")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SqlMonitorEditor.this._listUI) {
                    SqlMonitorEditor.this.updateList();
                } else {
                    SqlMonitorEditor.this.updateDetail(SqlMonitorEditor.this._conn, SqlMonitorEditor.this._sqlId, SqlMonitorEditor.this._sessionId, SqlMonitorEditor.this._sessionSerial, SqlMonitorEditor.this.editor);
                }
            }
        };
        abstractAction.putValue("ShortDescription", SqlMonitorArb.getString("REFRESH"));
        this._toolbar.add((Action)abstractAction);
        this._toolbar.addSeparator();
        this.back = new AbstractAction(SqlMonitorArb.getString("BACK"), OracleIcons.getIcon((String)"navigateBack.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SqlMonitorEditor.this.updateList();
            }
        };
        this.back.putValue("ShortDescription", SqlMonitorArb.getString("BACK"));
        if (this._listUI) {
            this.back.setEnabled(false);
        } else {
            this.back.setEnabled(true);
        }
        this._toolbar.add((Action)this.back);
        this._toolbar.addSeparator();
        JLabel jLabel = new JLabel(SqlMonitorArb.getString("REFRESH"));
        this._timerInterval = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._timerInterval.getModel();
        defaultComboBoxModel.addElement("0");
        defaultComboBoxModel.addElement("5");
        defaultComboBoxModel.addElement("10");
        defaultComboBoxModel.addElement("15");
        defaultComboBoxModel.addElement("20");
        defaultComboBoxModel.addElement("25");
        defaultComboBoxModel.addElement("30");
        defaultComboBoxModel.addElement("60");
        defaultComboBoxModel.addElement("120");
        this._timerInterval.setMaximumSize(this._timerInterval.getMinimumSize());
        this._timerInterval.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (SqlMonitorEditor.this._timer != null) {
                        SqlMonitorEditor.this._timer.cancel();
                        SqlMonitorEditor.this._timer = null;
                    }
                    if (!SqlMonitorEditor.this._timerInterval.getSelectedItem().equals("0")) {
                        SqlMonitorEditor.this._timer = new Timer();
                        SqlMonitorEditor.this._tt = new TimerTask(){

                            @Override
                            public void run() {
                                Connection connection = null;
                                try {
                                    connection = Connections.getInstance().getConnection(((SqlMonitorEditorNode)SqlMonitorEditor.this.getContext().getNode()).getConn());
                                }
                                catch (DBException dBException) {
                                    // empty catch block
                                }
                                if (connection == null || !SqlMonitorEditor.this.connectionOK(connection)) {
                                    SqlMonitorEditor.this._timer.cancel();
                                    SqlMonitorEditor.this._timer = null;
                                    SqlMonitorEditor.this._timerInterval.setSelectedItem("0");
                                } else if (SqlMonitorEditor.this._listUI) {
                                    SqlMonitorEditor.this.updateList();
                                } else {
                                    SqlMonitorEditor.this.updateDetail(SqlMonitorEditor.this._conn, SqlMonitorEditor.this._sqlId, SqlMonitorEditor.this._sessionId, SqlMonitorEditor.this._sessionSerial, SqlMonitorEditor.this.editor);
                                }
                            }
                        };
                        SqlMonitorEditor.this._timer.scheduleAtFixedRate(SqlMonitorEditor.this._tt, 0L, Long.parseLong((String)SqlMonitorEditor.this._timerInterval.getSelectedItem()) * 1000L);
                    }
                }
            }
        });
        this._toolbar.add((Component)jLabel);
        this._toolbar.add((Component)this._timerInterval);
        this._saveAction = IdeAction.get((int)11).newLocalAction((View)this);
        this._saveAction.addControllerLast((Controller)this);
        this._toolbar.add((ToggleAction)this._saveAction);
    }

    public void open() {
    }

    public void close() {
        if (this._list != null) {
            this._list.close();
        }
    }

    public Component getGUI() {
        return this._panel;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void editorShown() {
        SqlMonitorEditor.updateToolbarActions((Toolbar)this._toolbar);
    }

    public void editorHidden() {
        SqlMonitorEditor.updateToolbarActions((Toolbar)this._toolbar);
    }

    public void saveActiveReport() {
        int n = 0;
        URLFileChooser uRLFileChooser = null;
        uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter("HTML", ".html"));
        n = uRLFileChooser.showSaveDialog(this.getGUI());
        if (n == 0) {
            URL uRL = uRLFileChooser.getSelectedURL();
            Writer writer = null;
            try {
                writer = FileUtils.getEncodedFileWriter((String)uRL.getFile(), null);
                writer.write("<?xml version = '1.0' encoding = 'UTF-8'?>\r\n<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/><base href=\"http://download.oracle.com/otn_software/\"/><script language=\"javascript\" type=\"text/javascript\" src=\"emviewers/scripts/flashver.js\"><!--Test flash version--></script><style>\r\n      body { margin: 0px; overflow:hidden }\r\n    </style></head><body scroll=\"no\"><script type=\"text/xml\"><!--FXTMODEL-->");
                writer.write(this._detailPanel.getModel().getXML());
                writer.write("<!--FXTMODEL--></script><script language=\"JavaScript\" type=\"text/javascript\" src=\"emviewers/scripts/loadswf.js\"><!--Load report viewer--></script><iframe name=\"_history\" frameborder=\"0\" scrolling=\"no\" width=\"22\" height=\"0\"><html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"/><script type=\"text/javascript\" language=\"JavaScript1.2\" charset=\"utf-8\">\r\n                var v = new top.Vars(top.getSearch(window));\r\n                var fv = v.toString('$_');\r\n              </script></head><body><script type=\"text/javascript\" language=\"JavaScript1.2\" charset=\"utf-8\" src=\"emviewers/scripts/document.js\"><!--Run document script--></script></body></html></iframe></body></html>");
                writer.close();
            }
            catch (IOException iOException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)iOException.getLocalizedMessage(), (String)iOException.getLocalizedMessage(), null);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == this._saveAction.getCommandId()) {
            this.saveActiveReport();
            return true;
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == this._saveAction.getCommandId()) {
            this._saveAction.setEnabled(!this._listUI);
            return true;
        }
        return false;
    }

    public void stopTimer() {
        this._timer.cancel();
        this._timer = null;
        this._timerInterval.setSelectedItem("0");
    }

    public void updateList() {
        DatabaseQueryTask<Object> databaseQueryTask = new DatabaseQueryTask<Object>(SqlMonitorArb.getString("OPENING"), IRaptorTaskRunMode.MODAL_OPTIONAL, false, true){

            protected Object doWork() throws TaskException {
                SqlMonitorEditor.this.updateListImpl();
                return null;
            }

            public String getConnectionName() {
                return ((SqlMonitorEditorNode)SqlMonitorEditor.this.getContext().getNode()).getConn();
            }

            public String getQuery() {
                if (SqlMonitorEditor.this._list == null) {
                    SqlMonitorEditor.this.initList();
                }
                return SqlMonitorEditor.this._list.getSQL();
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
    }

    private void initList() {
        if (this._list == null || !this._listUI) {
            this._ui.removeAll();
            if (this._list == null) {
                this._list = new ListPanel(((SqlMonitorEditorNode)this.getContext().getNode()).getConn(), null, null, null, this.editor);
            }
            this._ui.add((Component)this._list, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this._list.refresh();
            SqlMonitorEditor.updateToolbarActions((Toolbar)this._toolbar);
        }
    }

    private void updateListImpl() {
        if (!this._listUI && this._timer != null) {
            this._timer.cancel();
            this._timer = null;
            this._timerInterval.setSelectedItem("0");
        }
        this.back.setEnabled(false);
        this.initList();
        this._listUI = true;
        SqlMonitorEditor.updateToolbarActions((Toolbar)this._toolbar);
        this._panel.validate();
    }

    public void updateDetail(Connection connection, String string, int n, int n2, SqlMonitorEditor sqlMonitorEditor) {
        if (this._listUI && this._timer != null) {
            this._timer.cancel();
            this._timer = null;
            this._timerInterval.setSelectedItem("0");
        }
        this.back.setEnabled(true);
        this._conn = connection;
        this._sqlId = string;
        this._sessionId = n;
        this._sessionSerial = n2;
        if (this._detailPanel == null || this._listUI) {
            this._ui.removeAll();
            this._detailPanel = new DetailTreePanel(connection, string, n, n2);
            this._detailPanel.expandTree();
            this._ui.add((Component)this._detailPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this._detailPanel.refresh();
        }
        this._listUI = false;
        this._panel.validate();
        SqlMonitorEditor.updateToolbarActions((Toolbar)this._toolbar);
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public Connection getConnection() {
        try {
            return Connections.getInstance().getConnection(this.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            return null;
        }
    }

    public Database getDatabase() {
        try {
            return Connections.getInstance().getDatabase(this.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            return null;
        }
    }

    public String getConnectionName() {
        return ((SqlMonitorEditorNode)this.getContext().getNode()).getConn();
    }

    public Controller getController() {
        return SqlMonitorController.getInstance();
    }
}

