/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.text.Collator;
import java.util.Comparator;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;

public class XmlCreatableDisplayNameComparator
implements Comparator {
    private Collator _collator;
    private XmlCreationContext _context;

    public XmlCreatableDisplayNameComparator(XmlCreationContext context) {
        this(context, null);
    }

    public XmlCreatableDisplayNameComparator(XmlCreationContext context, Collator c) {
        if (context == null) {
            throw new IllegalArgumentException("XmlCreationContext must not be null");
        }
        this._context = context;
        if (c == null) {
            c = Collator.getInstance(context.getModel().getContext().getLocale());
        }
        this._collator = c;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof XmlCreatable && o2 instanceof XmlCreatable) {
            XmlCreatable c1 = (XmlCreatable)o1;
            XmlCreatable c2 = (XmlCreatable)o2;
            int c1DisplayOrder = c1.getDisplayOrder(this._context);
            int c2DisplayOrder = c2.getDisplayOrder(this._context);
            if (c1DisplayOrder == -1 && c2DisplayOrder == -1) {
                return this._collator.compare(c1.getShortDisplayName(this._context), c2.getShortDisplayName(this._context));
            }
            if (c1DisplayOrder == -1) {
                return 1;
            }
            if (c2DisplayOrder == -1) {
                return -1;
            }
            return c1DisplayOrder - c2DisplayOrder;
        }
        if (o1 instanceof XmlCreatable) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof XmlCreatableDisplayNameComparator;
    }
}

