/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.share.collection.OptimisticHashMap;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.FilteredTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.ProxyingElement;
import oracle.bali.xml.dom.view.standalone.ProxyingNode;
import oracle.bali.xml.dom.view.standalone.StandaloneElement;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.view.AbstractSlotsFolderView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SlotsFolderViewTraversal
extends TreeTraversal
implements GrammarResolverListener {
    private static final String _BOGUS_NAMESPACE = "http://xmlns.oracle.com/bogus";
    private static final String _CHILD_SLOTS_LOCAL_NAME = "slots";
    private static final XmlKey _CHILD_SLOTS_KEY = ImmutableXmlKey.createElementKey((String)"http://xmlns.oracle.com/bogus", (String)"slots");
    private final HashMap _childSlotsNodes = new HashMap();
    private final HashMap _namedChildProxies = new HashMap();
    private final OptimisticHashMap _parentKeyToPotentialSlots = new OptimisticHashMap();
    private final TreeTraversal _ignoreSlotsTraversal = new IgnoreSlotsTraversal();
    private final AbstractSlotsFolderView _view;

    public SlotsFolderViewTraversal(AbstractSlotsFolderView view) {
        this._view = view;
    }

    public XmlKey getSlotsFolderKey() {
        return _CHILD_SLOTS_KEY;
    }

    public final boolean isSlotsFolderNode(Node node) {
        if (node == null) {
            return true;
        }
        return _BOGUS_NAMESPACE == node.getNamespaceURI();
    }

    public final boolean isSlotsFolderKey(Object key) {
        return _CHILD_SLOTS_KEY.equals(key);
    }

    public final boolean isNamedChildSlotProxy(Node node) {
        Node parentNode = node.getParentNode();
        return parentNode != null && this.isSlotsFolderNode(parentNode);
    }

    public final boolean isFakeNamedChildSlotProxy(Node node) {
        if (this.isNamedChildSlotProxy(node)) {
            return !(node instanceof ProxyingNode);
        }
        return false;
    }

    public Node getParentNode(Node node) {
        Node parentNode;
        Object proxyingNode = this._namedChildProxies.get(node);
        if (proxyingNode != null) {
            node = (Node)proxyingNode;
        }
        if ((parentNode = node.getParentNode()) == null) {
            return null;
        }
        if (this._view.isSlot(parentNode)) {
            this.getChildSlotsNode(parentNode.getParentNode());
            return (Node)this._namedChildProxies.get(parentNode);
        }
        return parentNode;
    }

    public Node getFirstChild(Node parentNode) {
        if (this.isSlotsFolderNode(parentNode)) {
            return parentNode.getFirstChild();
        }
        Node regularFirst = this._ignoreSlotsTraversal.getFirstChild(parentNode);
        if (regularFirst != null) {
            return regularFirst;
        }
        if (this._view.isSlotParent(parentNode)) {
            return this.getChildSlotsNode(parentNode);
        }
        return null;
    }

    public Node getLastChild(Node parentNode) {
        Node slotsFolder;
        if (this.isSlotsFolderNode(parentNode)) {
            return parentNode.getLastChild();
        }
        if (this._view.isSlotParent(parentNode) && (slotsFolder = this.getChildSlotsNode(parentNode)) != null) {
            return slotsFolder;
        }
        return this._ignoreSlotsTraversal.getLastChild(parentNode);
    }

    public Node getNextSibling(Node node) {
        if (!this.isSlotsFolderNode(node)) {
            Node slotsFolder;
            Node parentNode = node.getParentNode();
            if (this.isSlotsFolderNode(parentNode)) {
                return node.getNextSibling();
            }
            Node nextNode = this._ignoreSlotsTraversal.getNextSibling(node);
            if (nextNode != null) {
                return nextNode;
            }
            if (this._view.isSlotParent(parentNode) && (slotsFolder = this.getChildSlotsNode(parentNode)) != null) {
                return slotsFolder;
            }
        }
        return null;
    }

    public Node getPreviousSibling(Node node) {
        Node parentNode = node.getParentNode();
        if (this.isSlotsFolderNode(node)) {
            return this._ignoreSlotsTraversal.getLastChild(parentNode);
        }
        if (this.isSlotsFolderNode(parentNode)) {
            return node.getPreviousSibling();
        }
        return this._ignoreSlotsTraversal.getPreviousSibling(node);
    }

    public void updateCache(Node subtreeNode) {
        Document doc = this._view.getDocument();
        if (doc == null) {
            return;
        }
        if (subtreeNode == doc || subtreeNode == doc.getDocumentElement()) {
            for (Map.Entry currEntry : this._childSlotsNodes.entrySet()) {
                StandaloneElement fakeChildSlot = (StandaloneElement)currEntry.getValue();
                if (fakeChildSlot == null) continue;
                fakeChildSlot.setParentNode(null);
            }
            this._childSlotsNodes.clear();
            this._namedChildProxies.clear();
            return;
        }
        LinkedList<Node> childSlotList = null;
        for (Node currParent : this._childSlotsNodes.keySet()) {
            if (!DomUtils.isNodeOrDescendant((Node)currParent, (Node)subtreeNode)) continue;
            if (childSlotList == null) {
                childSlotList = new LinkedList<Node>();
            }
            childSlotList.add(currParent);
        }
        if (childSlotList != null) {
            HashMap namedChildProxies = this._namedChildProxies;
            HashMap childSlotNodes = this._childSlotsNodes;
            for (Object e : childSlotList) {
                Object childEntry = childSlotNodes.remove(e);
                if (childEntry == null) continue;
                StandaloneElement fakeChildSlot = (StandaloneElement)childEntry;
                Node currProxy = fakeChildSlot.getFirstChild();
                if (currProxy != null) {
                    do {
                        if (!(currProxy instanceof ProxyingNode)) continue;
                        Node proxiedNode = ((ProxyingNode)((Object)currProxy)).getProxiedNode();
                        namedChildProxies.remove(proxiedNode);
                    } while ((currProxy = currProxy.getNextSibling()) != null);
                }
                fakeChildSlot.setParentNode(null);
            }
        }
    }

    public Node getChildSlotsNode(Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        Node childSlotsNode = (Node)this._childSlotsNodes.get(parentNode);
        if (childSlotsNode == null) {
            childSlotsNode = null;
            List namedChildList = this._getPotentialSlotKeys(parentNode);
            if (!namedChildList.isEmpty()) {
                childSlotsNode = this._createFakeChildrenNode(parentNode, namedChildList);
            }
            this._childSlotsNodes.put(parentNode, childSlotsNode);
        }
        return childSlotsNode;
    }

    public void grammarResolverChanged(GrammarResolverEvent e) {
        this._parentKeyToPotentialSlots.clear();
    }

    Node __getNamedChildSlotProxy(Node modelNamedChildSlot, boolean initChildSlotCache) {
        Node parentUINode;
        Node childSlots;
        if (modelNamedChildSlot == null) {
            return null;
        }
        Node proxyNode = (Node)this._namedChildProxies.get(modelNamedChildSlot);
        if (proxyNode == null && (childSlots = this.getChildSlotsNode(parentUINode = modelNamedChildSlot.getParentNode())) != null && (proxyNode = (Node)this._namedChildProxies.get(modelNamedChildSlot)) == null && initChildSlotCache) {
            this.updateCache(parentUINode);
            childSlots = this.getChildSlotsNode(parentUINode);
            if (childSlots != null) {
                proxyNode = (Node)this._namedChildProxies.get(modelNamedChildSlot);
            }
        }
        return proxyNode;
    }

    private List _getPotentialSlotKeys(Node parentNode) {
        XmlKey parentKey = this._view.getNodeXmlKey(parentNode);
        if (!this._view.isSlotParent(parentKey)) {
            return Collections.EMPTY_LIST;
        }
        List cached = (List)this._parentKeyToPotentialSlots.get((Object)parentKey);
        if (cached != null) {
            return cached;
        }
        List created = this._view.createSortedSlotKeyList(parentKey);
        this._parentKeyToPotentialSlots.put((Object)parentKey, (Object)created);
        return created;
    }

    private Node _createFakeChildrenNode(Node parentNode, List slotKeys) {
        XmlMetadataResolver resolver = this._view.getXmlMetadataResolver();
        Document viewDocument = this._view.getDocument();
        StandaloneElement fakeChildrenNode = new StandaloneElement(viewDocument, _BOGUS_NAMESPACE, null, _CHILD_SLOTS_LOCAL_NAME);
        fakeChildrenNode.setParentNode(parentNode);
        Map slotNodes = this._getSlotNodes(parentNode);
        int namedChildCount = slotKeys.size();
        for (int i = 0; i < namedChildCount; ++i) {
            XmlKey slotKey = (XmlKey)slotKeys.get(i);
            Node currentSlotNode = (Node)slotNodes.get(slotKey);
            StandaloneElement currChildNode = null;
            if (currentSlotNode != null) {
                if (currentSlotNode.getOwnerDocument() != fakeChildrenNode.getOwnerDocument()) {
                    currentSlotNode = fakeChildrenNode.getOwnerDocument().importNode(currentSlotNode, false);
                }
                ProxyingElement proxyElement = new ProxyingElement((Element)currentSlotNode, false);
                this._namedChildProxies.put(currentSlotNode, proxyElement);
                currChildNode = proxyElement;
            } else if (!resolver.isDeprecated(slotKey)) {
                QualifiedName slotQName = slotKey.getElementQName();
                String prefix = this._getPrefix(slotQName.getNamespace(), parentNode, resolver);
                currChildNode = new StandaloneElement(viewDocument, slotQName.getNamespace(), prefix, slotQName.getName());
                if (slotQName.getAttributeName() != null) {
                    ((Element)currChildNode).setAttributeNS(slotQName.getAttributeNamespace(), slotQName.getAttributeName(), slotQName.getAttributeValue());
                }
            }
            if (currChildNode == null) continue;
            fakeChildrenNode.appendChild(currChildNode);
        }
        return fakeChildrenNode;
    }

    private Map _getSlotNodes(Node slotsContainerNode) {
        DocumentTreeTraversal traversal = DocumentTreeTraversal.INSTANCE;
        Node firstSlotNode = null;
        HashMap<XmlKey, Node> slotNodes = null;
        Node currChild = traversal.getFirstChild(slotsContainerNode);
        while (currChild != null) {
            if (this._view.isSlot(currChild)) {
                if (slotNodes == null) {
                    if (firstSlotNode == null) {
                        firstSlotNode = currChild;
                    } else {
                        slotNodes = new HashMap<XmlKey, Node>(traversal.getChildCount(slotsContainerNode));
                        slotNodes.put(this._view.getNodeXmlKey(firstSlotNode), firstSlotNode);
                        slotNodes.put(this._view.getNodeXmlKey(currChild), currChild);
                    }
                } else {
                    slotNodes.put(this._view.getNodeXmlKey(currChild), currChild);
                }
            }
            currChild = traversal.getNextSibling(currChild);
        }
        if (slotNodes == null) {
            if (firstSlotNode != null) {
                return Collections.singletonMap(this._view.getNodeXmlKey(firstSlotNode), firstSlotNode);
            }
            return Collections.EMPTY_MAP;
        }
        return slotNodes;
    }

    private String _getPrefix(String namespace, Node parent, XmlMetadataResolver resolver) {
        String prefix = DomUtils.lookupPrefix((String)namespace, (Node)parent);
        if (prefix == null) {
            prefix = resolver.getPreferredPrefix(ImmutableXmlKey.createNamespaceKey((String)namespace));
        }
        return prefix;
    }

    private class IgnoreSlotsTraversal
    extends FilteredTreeTraversal {
        private IgnoreSlotsTraversal() {
        }

        protected short acceptNode(Node node) {
            if (SlotsFolderViewTraversal.this._view.isSlot(node)) {
                return 2;
            }
            return 1;
        }
    }
}

