/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.resource;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.share.collection.CompoundEnumeration;
import oracle.bali.xml.share.NoDuplicatesEnumeration;
import oracle.javatools.util.Tuple;

public final class PaternalResourceBundle
extends ResourceBundle {
    private static final int _AVERAGE_RESOURCE_SIZE = 101;
    private static final ResourceBundle[] _EMPTY_ARRAY = new ResourceBundle[0];
    private static final ConcurrentHashMap<Tuple<ResourceBundle, ResourceBundle>, PaternalResourceBundle> _sCombinedBundleCache = new ConcurrentHashMap();
    private String[] _bundleNames;
    private Locale _locale;
    private transient Enumeration _keys;
    private transient ResourceBundle[] _bundles;
    private transient HashMap _valueCache;

    public static PaternalResourceBundle getOrCreateCachedBundle(ResourceBundle one, ResourceBundle two) {
        PaternalResourceBundle newBundle;
        Tuple pair = new Tuple((Object)one, (Object)two);
        PaternalResourceBundle combinedBundle = _sCombinedBundleCache.get(pair);
        if (combinedBundle == null && (combinedBundle = _sCombinedBundleCache.putIfAbsent((Tuple<ResourceBundle, ResourceBundle>)pair, newBundle = new PaternalResourceBundle(new ResourceBundle[]{one, two}))) == null) {
            combinedBundle = newBundle;
        }
        return combinedBundle;
    }

    public PaternalResourceBundle(String[] bundleNames) {
        this(bundleNames, null);
    }

    public PaternalResourceBundle(ResourceBundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            throw new IllegalArgumentException();
        }
        this._bundles = this._flattenBundles(bundles);
    }

    public PaternalResourceBundle(String[] bundleNames, Locale locale) {
        int bundleCount = bundleNames.length;
        if (bundleNames == null || bundleCount == 0) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String[] tempBundleNames = new String[bundleCount];
        System.arraycopy(bundleNames, 0, tempBundleNames, 0, bundleCount);
        this._bundleNames = bundleNames;
        this._locale = locale;
    }

    public Enumeration getKeys() {
        int bundleCount;
        if (this._bundles == null) {
            this._createBundles();
        }
        if ((bundleCount = this._bundles.length) > 1) {
            CompoundEnumeration currEnumeration = new CompoundEnumeration(this._bundles[0].getKeys(), this._bundles[1].getKeys());
            for (int currIndex = 2; currIndex < bundleCount; ++currIndex) {
                currEnumeration = new CompoundEnumeration((Enumeration)currEnumeration, this._bundles[currIndex].getKeys());
            }
            return new NoDuplicatesEnumeration((Enumeration)currEnumeration);
        }
        if (bundleCount == 1) {
            return this._bundles[0].getKeys();
        }
        return null;
    }

    public String toString() {
        if (this._bundles == null) {
            this._createBundles();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Paternal-bundle(");
        for (int i = 0; i < this._bundles.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this._bundles[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    protected Object handleGetObject(String key) throws MissingResourceException {
        int bundleCount;
        if (this._bundles == null) {
            this._createBundles();
        }
        if ((bundleCount = this._bundles.length) > 1) {
            Object result;
            if (this._valueCache == null) {
                this._createValueCache(bundleCount);
            }
            if ((result = this._valueCache.get(key)) == null) {
                int i = 0;
                while (true) {
                    try {
                        result = this._bundles[i].getObject(key);
                        this._valueCache.put(key, result);
                    }
                    catch (MissingResourceException e) {
                        if (++i != bundleCount) continue;
                        throw e;
                    }
                    break;
                }
            }
            return result;
        }
        if (bundleCount == 1) {
            return this._bundles[0].getObject(key);
        }
        return null;
    }

    private ResourceBundle[] _flattenBundles(ResourceBundle[] bundles) {
        int bundleCount = bundles.length;
        LinkedHashSet flattenedBundles = new LinkedHashSet(2 * bundleCount);
        this._flattenBundles(bundles, flattenedBundles);
        return flattenedBundles.toArray(_EMPTY_ARRAY);
    }

    private void _flattenBundles(ResourceBundle[] bundles, LinkedHashSet flattenedBundles) {
        for (ResourceBundle currBundle : bundles) {
            if (currBundle == null) continue;
            if (currBundle instanceof PaternalResourceBundle) {
                PaternalResourceBundle paternalBundle = (PaternalResourceBundle)currBundle;
                this._flattenBundles(paternalBundle._bundles, flattenedBundles);
                continue;
            }
            flattenedBundles.add(currBundle);
        }
    }

    private void _createBundles() {
        int bundleCount = this._bundleNames.length;
        ResourceBundle[] bundles = new ResourceBundle[bundleCount];
        for (int i = 0; i < bundleCount; ++i) {
            try {
                bundles[i] = PaternalResourceBundle.getBundle(this._bundleNames[i], this._locale);
                continue;
            }
            catch (MissingResourceException e) {
                bundles[i] = null;
            }
        }
        this._bundles = this._flattenBundles(bundles);
    }

    private void _createValueCache(int bundleCount) {
        if (bundleCount < 2) {
            throw new IllegalArgumentException();
        }
        this._valueCache = new HashMap(101 * bundleCount);
    }
}

