/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.misc;

import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptionsDecorator;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.automata.AutomataBuilder;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.DomNodeXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlModelBasedTextSyncOptions
extends TextSyncOptionsDecorator {
    private final XmlContext _context;
    private final TextSyncOptions _base;

    public XmlModelBasedTextSyncOptions(XmlContext context, TextSyncOptions base) {
        if (base == null) {
            base = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS;
        }
        this._context = context;
        this._base = base;
    }

    public XmlModelBasedTextSyncOptions(XmlContext context) {
        this(context, null);
    }

    @Override
    public boolean prefersWhitespaceInside(Element element) {
        ElementDef gc = this._getElementDef(element);
        if (TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)gc)) {
            return false;
        }
        return super.prefersWhitespaceInside(element);
    }

    @Override
    public boolean useMinimizedForm(Element element) {
        ElementDef def = this._getElementDef(element);
        if (def != null) {
            State state;
            if (TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)def)) {
                return false;
            }
            ComplexType type = (ComplexType)def.getType();
            ContentGroup contentGroup = type.getContentGroup();
            if (contentGroup != null && (state = AutomataBuilder.buildAutomata((ContentGroup)contentGroup)) != null && !state.isFinalState()) {
                return false;
            }
        }
        return super.useMinimizedForm(element);
    }

    @Override
    protected TextSyncOptions getBaseTextSyncOptions() {
        return this._base;
    }

    protected final XmlContext getXmlContext() {
        return this._context;
    }

    private ElementDef _getElementDef(Element elem) {
        XmlModel model = this._context.getSourceModel();
        if (model != null) {
            return (ElementDef)model.getXmlMetadataResolver().getGrammarComponent(elem);
        }
        GrammarResolver resolver = this._context.getGrammarResolver();
        XmlKey key = DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)resolver, (Node)elem);
        return (ElementDef)GrammarUtils.getGrammarComponent((GrammarResolver)resolver, (XmlKey)key);
    }
}

