/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.listenerImpl;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;

public abstract class BaseEventTask {
    protected static final short LISTENER_ATTACHED = 0;
    protected static final short LISTENER_DETACHED = 1;
    protected static final short INVALIDATE = 2;
    protected static final short MODEL_CHANGED = 3;
    protected static final short NO_CHANGE = 4;
    protected static final Logger LOGGER = Logger.getLogger("oracle.bali.xml.model");
    protected static final List<XmlModelListener> _EMPTY_LISTENER_LIST = Collections.emptyList();

    protected final void deliverEventHelper(List<XmlModelListener> listeners, XmlModelEvent event, short eventType) {
        this.deliverEventHelper(listeners, _EMPTY_LISTENER_LIST, event, eventType);
    }

    protected final void deliverEventHelper(List<XmlModelListener> listeners, List<XmlModelListener> suppressedListeners, XmlModelEvent event, short eventType) {
        for (XmlModelListener listener : listeners) {
            try {
                if (suppressedListeners.contains(listener)) continue;
                switch (eventType) {
                    case 0: {
                        listener.listenerAttached(event);
                        break;
                    }
                    case 1: {
                        listener.listenerDetached(event);
                        break;
                    }
                    case 2: {
                        listener.invalidate(event);
                        break;
                    }
                    case 3: {
                        listener.modelChanged(event);
                        break;
                    }
                    case 4: {
                        listener.noChange(event);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid XmlModel Message Type:  " + eventType);
                    }
                }
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Unexpected throwable while delivering XmlModelEvent", t);
            }
        }
    }
}

