/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.grammar;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.GrammarIdentifier;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.share.PropertyChange;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class InstanceGrammarListener
extends XmlModelAdapter {
    @Override
    public void listenerAttached(XmlModelEvent event) {
        this._processEvent(event);
    }

    @Override
    public void listenerDetached(XmlModelEvent event) {
        this._processEvent(event);
    }

    @Override
    public void modelChanged(XmlModelEvent event) {
        this._processEvent(event);
    }

    private void _processEvent(XmlModelEvent event) {
        AbstractModel model = event.getModel();
        XmlContext context = model.getContext();
        GrammarProvider contextProvider = context.getGrammarProvider();
        if ((event.isDomTreeChanged() || event.getCachedUrlMapPropertyChange() != null) && contextProvider instanceof XmlInstanceGrammarProvider) {
            XmlInstanceGrammarProvider instanceProvider = (XmlInstanceGrammarProvider)contextProvider;
            GrammarIdentifier dtdIdentifier = null;
            Set schemaIdentifiers = new HashSet();
            Document document = model.getDocument();
            if (document != null) {
                Element root;
                DocumentType docType = document.getDoctype();
                if (docType != null) {
                    String publicId = docType.getPublicId();
                    String systemId = docType.getSystemId();
                    if (publicId != null || systemId != null) {
                        dtdIdentifier = this._createIdentifier(context, null, publicId, systemId);
                    }
                }
                if ((root = document.getDocumentElement()) != null) {
                    DocumentTraversal dt = (DocumentTraversal)((Object)document);
                    NodeIterator iter = dt.createNodeIterator(root, 1, null, false);
                    Node next = iter.nextNode();
                    while (next != null) {
                        Element element = (Element)next;
                        if (element.hasAttributes()) {
                            Attr schemaLoc = element.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                            Attr noNamespace = element.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
                            if (schemaLoc != null) {
                                this._processSchemaLocationAttr(context, schemaLoc, schemaIdentifiers);
                            }
                            if (noNamespace != null) {
                                this._processNoNamespaceAttr(context, noNamespace, schemaIdentifiers);
                            }
                        }
                        next = iter.nextNode();
                    }
                    iter.detach();
                }
            }
            schemaIdentifiers = this.findSchemaIndentifiersHook(context, schemaIdentifiers);
            boolean forceReload = false;
            PropertyChange cachedUrlMap = event.getCachedUrlMapPropertyChange();
            if (cachedUrlMap != null) {
                Map map = (Map)cachedUrlMap.getNewValue();
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() != ValidationResult.OK) continue;
                    forceReload = true;
                }
            }
            instanceProvider.setSchemaIdentifiers(schemaIdentifiers, forceReload);
            instanceProvider.setDtdIdentifier(dtdIdentifier);
        }
    }

    protected Set findSchemaIndentifiersHook(XmlContext context, Set identifiers) {
        return identifiers;
    }

    private void _processSchemaLocationAttr(XmlContext context, Attr attr, Set identifiers) {
        String value = attr.getValue();
        if (value != null) {
            List tokens = this._getTokens(value);
            int numTokens = tokens.size();
            int currentNamespace = 0;
            for (int currentLocation = 1; currentLocation < numTokens; currentLocation += 2) {
                String sNamespace = (String)tokens.get(currentNamespace);
                String sLocation = (String)tokens.get(currentLocation);
                GrammarIdentifier temp = this._createIdentifier(context, sNamespace, null, sLocation);
                identifiers.add(temp);
                currentNamespace += 2;
            }
        }
    }

    private void _processNoNamespaceAttr(XmlContext context, Attr attr, Set identifiers) {
        String value = attr.getValue();
        if (value != null && value.length() > 0) {
            GrammarIdentifier temp = this._createIdentifier(context, null, null, value);
            identifiers.add(temp);
        }
    }

    private List _getTokens(String spaceSeparatedList) {
        ArrayList<String> tokens = Collections.EMPTY_LIST;
        if (spaceSeparatedList != null) {
            String token;
            int iter;
            tokens = new ArrayList<String>(6);
            char[] chars = spaceSeparatedList.toCharArray();
            int startTokenOffset = -1;
            block3: for (iter = 0; iter < chars.length; ++iter) {
                char currentChar = chars[iter];
                switch (currentChar) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (startTokenOffset == -1) continue block3;
                        token = new String(chars, startTokenOffset, iter - startTokenOffset);
                        tokens.add(token);
                        startTokenOffset = -1;
                        continue block3;
                    }
                    default: {
                        if (startTokenOffset != -1) continue block3;
                        startTokenOffset = iter;
                    }
                }
            }
            if (startTokenOffset != -1) {
                token = new String(chars, startTokenOffset, iter - startTokenOffset);
                tokens.add(token);
                startTokenOffset = -1;
            }
        }
        return tokens;
    }

    private GrammarIdentifier _createIdentifier(XmlContext context, String namespace, String publicId, String location) {
        String resolvedLocation = this._resolveLocation(context, location);
        return GrammarIdentifier.getGrammarIdentifier((String)namespace, (String)publicId, (String)resolvedLocation);
    }

    private String _resolveLocation(XmlContext context, String location) {
        URL resolvedURL;
        if (location != null && (resolvedURL = context.getURLForRelativePath(location)) != null) {
            return resolvedURL.toExternalForm();
        }
        return location;
    }
}

