/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractPositionTargetingOperation;
import oracle.bali.xml.model.datatransfer.operation.CopyOperation;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.DocumentFragment;

class CreateFromFragmentOperation
extends AbstractPositionTargetingOperation {
    private static final Logger _LOGGER = Logger.getLogger(CreateFromFragmentOperation.class.getName());

    CreateFromFragmentOperation() {
    }

    @Override
    public boolean apply(AbstractModel model, final DomPosition pos, final TransferDataInfo data, final TransactionToken token) throws IOException, XmlCommitException {
        final String txnName = this.getDisplayName(model, data);
        final Value value = new Value();
        new FixedNameTransactionTask(txnName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                XmlContext context = model.getContext();
                context.setTransactionToken(token);
                try {
                    DocumentFragment fragment = (DocumentFragment)data.getData(FetchMode.STANDARD, false);
                    value.setValue(fragment);
                }
                catch (IOException ioe) {
                    _LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
                }
            }
        }.runThrowingXCE(model);
        final DocumentFragment fragment = (DocumentFragment)value.getValue();
        if (fragment != null) {
            final StandardTransactionTask callback = (StandardTransactionTask)data.getMetadata(XmlTransferUtils.KEY_TASK_TO_EXECUTE_AFTER_INSERTING_FRAGMENT);
            boolean ok = new NoNameTransactionTask(){

                @Override
                protected void performTask(AbstractModel model) throws XmlCommitException {
                    Collection ret = CopyOperation.__insertNodes(model, pos, fragment, txnName, token);
                    if (ret == null) {
                        this.cancelTask();
                    }
                    if (callback != null) {
                        callback.runThrowingXCE(model);
                    }
                }
            }.runThrowingXCE(model);
            return ok;
        }
        return false;
    }

    @Override
    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragCreate");
        }
        return model.getTranslatedString("DragCreate_Data", infoDesc);
    }

    @Override
    public float getSuitabilityRank() {
        return 0.9f;
    }

    @Override
    public int getSupportedActions() {
        return 1;
    }

    @Override
    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_DOCUMENTFRAGMENT;
    }

    @Override
    protected boolean isValidData(AbstractModel model, TransferDataInfo info, Object datum) {
        return super.isValidData(model, info, datum) && (datum == null || datum instanceof DocumentFragment) && !XmlTransferUtils.hasOriginalNodesOrRange(info);
    }

    @Override
    protected boolean isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        if (!super.isValidPosition(model, pos, info, datum)) {
            return false;
        }
        return CopyOperation.__isValidPosition(model, pos, info, datum);
    }

    @Override
    protected DomPosition convertPosition(AbstractModel model, DomPosition originalPos, Object datum) {
        return model.convertInsertionPosition(originalPos);
    }

    private final class Value<V> {
        private V _value;

        private Value() {
        }

        public V getValue() {
            return this._value;
        }

        public void setValue(V value) {
            this._value = value;
        }
    }
}

