/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.attributeValues;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.attributeValues.AttributeValueProviderDefinition;
import oracle.bali.xml.model.attributeValues.ValuesDefinition;

public final class AttributeValueProviderDefinitionFactory {
    private AttributeValueProviderDefinitionFactory() {
    }

    public static List<AttributeValueProviderDefinition> create(List<StructuredMetadataBean> list) {
        ArrayList<AttributeValueProviderDefinition> values = new ArrayList<AttributeValueProviderDefinition>(5);
        for (StructuredMetadataBean smb : list) {
            values.addAll(AttributeValueProviderDefinitionFactory.create(smb));
        }
        return values;
    }

    public static List<AttributeValueProviderDefinition> create(StructuredMetadataBean attributeValueProviderDeclarations) {
        if (attributeValueProviderDeclarations == null || !XmlMetadataConstants.ATTRIBUTE_VALUE_PROVIDER_DECLARATIONS.equals((Object)attributeValueProviderDeclarations.getName())) {
            throw new IllegalStateException("StructuredMetadataBean name wasn't as expected: " + attributeValueProviderDeclarations);
        }
        ArrayList<AttributeValueProviderDefinition> list = new ArrayList<AttributeValueProviderDefinition>(5);
        List children = attributeValueProviderDeclarations.getChildren();
        for (StructuredMetadataBean child : children) {
            list.add(AttributeValueProviderDefinitionFactory.createAttributeValueProviderDefinition(child));
        }
        return list;
    }

    private static AttributeValueProviderDefinition createAttributeValueProviderDefinition(StructuredMetadataBean attributeValueProvider) {
        if (attributeValueProvider == null || !XmlMetadataConstants.ATTRIBUTE_VALUE_PROVIDER_DECLARATION.equals((Object)attributeValueProvider.getName())) {
            throw new IllegalStateException("StructuredMetadataBean name wasn't as expected: " + attributeValueProvider);
        }
        AttributeValueProviderDefinition avpd = new AttributeValueProviderDefinition(attributeValueProvider.getProperty(XmlMetadataConstants.ID_ATTR));
        List children = attributeValueProvider.getChildren();
        for (StructuredMetadataBean child : children) {
            QualifiedName name = child.getName();
            if (XmlMetadataConstants.VALUES.equals((Object)name)) {
                List values = child.getChildren();
                ValuesDefinition vd = new ValuesDefinition();
                for (StructuredMetadataBean value : values) {
                    if (!XmlMetadataConstants.VALUE.equals((Object)value.getName())) continue;
                    vd.setValue(value.getValue());
                }
                avpd.setValue(vd);
                continue;
            }
            if (XmlMetadataConstants.CONSTRAINED.equals((Object)name)) {
                avpd.setConstrained(child.getValue());
                continue;
            }
            if (XmlMetadataConstants.QUERY_OTHER_SOURCES.equals((Object)name)) {
                avpd.setQueryOtherSources(child.getValue());
                continue;
            }
            if (XmlMetadataConstants.QUERY_GRAMMAR.equals((Object)name)) {
                avpd.setQueryGrammar(child.getValue());
                continue;
            }
            if (!XmlMetadataConstants.QUERY_PROPERTY_EDITOR_TAGS.equals((Object)name)) continue;
            avpd.setQueryPropertyEditorTags(child.getValue());
        }
        return avpd;
    }
}

