/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.task.SelectionBasedTransactionTask;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.bali.xml.util.XmlTransferableSelectionAction;
import org.w3c.dom.Node;

public class DuplicateAction
extends XmlTransferableSelectionAction {
    private static final StandardTransactionTask _TASK = new Task();

    public DuplicateAction(String mnemonicAndDisplayName) {
        super(mnemonicAndDisplayName, KeyStroke.getKeyStroke(75, 2), "duplicate", true, false);
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this._doDuplicate(this);
        }
        catch (XmlCommitException e) {
            this.getModel().getLogger().log(Level.SEVERE, "Validation failed in:" + this, e);
        }
    }

    private void _doDuplicate(ModelAction action) throws XmlCommitException {
        _TASK.runThrowingXCE(action.getModel());
    }

    private static class Task
    extends SelectionBasedTransactionTask {
        private Task() {
        }

        @Override
        protected void performTask(AbstractModel model) throws XmlCommitException {
            Collection clones = XmlModelUtils.getCloneOfSelection(model);
            if (!clones.isEmpty()) {
                model.insertNodes(DomPositionFactory.after((Node)model.getSelection().getLatestSelectedNode()), "duplicate", clones, true);
            }
        }

        @Override
        protected String computeMultipleSelectionTransactionName(AbstractModel model, int numSelected) {
            return model.getTranslatedString("DUPLICATE_DESCRIPTION_MULTIPLE");
        }

        @Override
        protected String computeSingleSelectionTransactionName(AbstractModel model) {
            Node node = model.getSelection().getLatestSelectedNode();
            String nodeDisplayName = model.getXmlMetadataResolver().getShortDisplayName(node);
            return model.getTranslatedString("DUPLICATE_DESCRIPTION_SINGULAR_FORMAT", nodeDisplayName);
        }
    }
}

