/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.xmlComponent;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.ToStringConverter;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.inspector.XmlComponentSupport;
import oracle.bali.xml.gui.base.inspector.editors.InspectorPropertyEditorSupport;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorAdapter;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.ide.util.Assert;
import org.w3c.dom.Node;

public abstract class AbstractXmlPropertyEditorFactoryDecorator<T>
extends InspectorPropertyEditorSupport
implements PropertyEditorFactory2,
PropertyEditor,
XmlComponentPropertyEditor {
    private Component _editorComponent;
    private boolean _xmlComponentFlag = false;
    private final PropertyEditorFactory2 _propertyEditor;
    private XmlComponentWrapper _xmlComponentWrapper;
    private boolean _suppressUpdatingXmlComponent = false;

    public AbstractXmlPropertyEditorFactoryDecorator(PropertyEditorFactory2 propertyEditor) {
        this._propertyEditor = propertyEditor;
    }

    @Override
    public final void setValue(Object o) {
        this._propertyEditor.setValue(o);
    }

    public T getValue() {
        return (T)this._propertyEditor.getValue();
    }

    @Override
    public boolean isPaintable() {
        return this._propertyEditor.isPaintable();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this._propertyEditor.paintValue(gfx, box);
    }

    @Override
    public final String getAsText() {
        return this._propertyEditor.getAsText();
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
        this._propertyEditor.setAsText(text);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this._propertyEditor.addPropertyChangeListener(l);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this._propertyEditor.removePropertyChangeListener(l);
    }

    @Override
    public String[] getTags() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).getTags();
        }
        if (this._propertyEditor instanceof AbstractXmlPropertyEditorAdapter) {
            return ((AbstractXmlPropertyEditorAdapter)this._propertyEditor).getBasePropertyEditor().getTags();
        }
        return null;
    }

    @Override
    public String getJavaInitializationString() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).getJavaInitializationString();
        }
        if (this._propertyEditor instanceof AbstractXmlPropertyEditorAdapter) {
            return ((AbstractXmlPropertyEditorAdapter)this._propertyEditor).getBasePropertyEditor().getJavaInitializationString();
        }
        return "???";
    }

    @Override
    public Component getCustomEditor() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).getCustomEditor();
        }
        if (this._propertyEditor instanceof AbstractXmlPropertyEditorAdapter) {
            return ((AbstractXmlPropertyEditorAdapter)this._propertyEditor).getBasePropertyEditor().getCustomEditor();
        }
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).supportsCustomEditor();
        }
        if (this._propertyEditor instanceof AbstractXmlPropertyEditorAdapter) {
            return ((AbstractXmlPropertyEditorAdapter)this._propertyEditor).getBasePropertyEditor().supportsCustomEditor();
        }
        return false;
    }

    public void applyValueFrom(Component c) {
        this._propertyEditor.applyValueFrom(c);
    }

    @Override
    public boolean hasInlineEditor() {
        return this._propertyEditor.hasInlineEditor();
    }

    @Override
    public Component getInlineEditor() {
        return this._propertyEditor.getInlineEditor();
    }

    public EditorComponentInfo getEditorComponentInfo() {
        return this._propertyEditor.getEditorComponentInfo();
    }

    public void setEditorComponentInfo(EditorComponentInfo editorComponentInfo) {
        this._propertyEditor.setEditorComponentInfo(editorComponentInfo);
    }

    public PropertyValueApplier getPropertyValueApplier() {
        return this._propertyEditor.getPropertyValueApplier();
    }

    public void setPropertyValueApplier(PropertyValueApplier propertyValueApplier) {
        this._propertyEditor.setPropertyValueApplier(propertyValueApplier);
    }

    @Override
    public void setSelectedItemToStringConverter(ToStringConverter selectedItemToStringConverter) {
        this._propertyEditor.setSelectedItemToStringConverter(selectedItemToStringConverter);
    }

    @Override
    public Component getXmlComponent() {
        this.setXmlComponentFlag(true);
        boolean addItemListener = false;
        if (this._editorComponent == null && this.getEditorComponentInfo() != null) {
            Component attributeValueComponent;
            this._editorComponent = attributeValueComponent = this.getAttributeValueComponent();
            if (this._editorComponent instanceof JComboBox && this.getXmlComponentWrapper().addFocusTracker()) {
                addItemListener = true;
            }
        }
        this.updateXmlComponentFromPropertyValue();
        this.setXmlComponentFlag(false);
        if (addItemListener) {
            ((JComboBox)this._editorComponent).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    AbstractXmlPropertyEditorFactoryDecorator.this.handleItemStateChanged(itemEvent);
                }
            });
        }
        return this._editorComponent;
    }

    private PropertyEditorFactory2 getAttributeValueEditor() {
        XmlKey xmlKey = this.getXmlComponentModel().getXmlKey();
        XmlGui xmlGui = this.getXmlComponentModel().getXmlGui();
        Node node = this.getXmlComponentModel().getNode();
        if (node == null) {
            node = this.getXmlComponentModel().getPrecreatedNode();
        }
        Node ownerNode = node;
        if (xmlKey.getNodeType() == 2) {
            ownerNode = this.getXmlComponentModel().getParentAttrNode();
        }
        XmlKey ownerKey = ImmutableXmlKey.createElementKey((List)xmlKey.getElementQNamePath());
        List<XmlKey> ancestors = Collections.singletonList(ownerKey);
        return XmlComponentSupport.createAttributeValueItemPropertyEditor(this._propertyEditor, xmlGui, xmlKey, node, ownerNode, ownerKey, ancestors);
    }

    private Component getAttributeValueComponent() {
        PropertyEditorFactory2 attributeValueItemPropertyEditor = this.getAttributeValueEditor();
        if (attributeValueItemPropertyEditor.getEditorComponentInfo() != null) {
            PropertyValueApplier propertyValueApplier = new PropertyValueApplier(){

                public void apply(Object newValue) {
                    AbstractXmlPropertyEditorFactoryDecorator.this.setValue(newValue);
                }
            };
            return XmlComponentSupport.getInlineEditorComponent(attributeValueItemPropertyEditor, propertyValueApplier);
        }
        return null;
    }

    @Override
    public void updateXmlComponentFromPropertyValue() {
        String textValue;
        if (this.suppressUpdatingXmlComponent()) {
            return;
        }
        if (this._editorComponent instanceof JTextComponent) {
            ((JTextComponent)this._editorComponent).setText(this.getAsText());
        } else if (this._editorComponent instanceof JComboBox && (textValue = this.getAsText()) != null) {
            this.setTextJComboBox(this.getAsText(), (JComboBox)this._editorComponent);
        }
    }

    public void setTextJComboBox(String text, JComboBox mComboBox) {
        mComboBox.setSelectedItem(null);
        boolean textSet = false;
        int itemCount = mComboBox.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            Object item = mComboBox.getItemAt(i);
            if (item instanceof AttributeValueItem) {
                AttributeValueItem itemAsAttributeValue = (AttributeValueItem)item;
                try {
                    if (!text.equals(itemAsAttributeValue.selectValue())) continue;
                    mComboBox.setSelectedItem(item);
                    textSet = true;
                    break;
                }
                catch (PropertyVetoException e) {
                    Assert.printStackTrace((Throwable)e);
                    continue;
                }
            }
            if (item == null || !text.equals(item.toString())) continue;
            mComboBox.setSelectedItem(item);
            textSet = true;
            break;
        }
        if (!textSet && mComboBox.isEditable()) {
            mComboBox.setSelectedItem(text);
        }
    }

    @Override
    public void updatePropertyValueFromXmlComponent() {
        if (this._editorComponent instanceof JTextComponent) {
            String textValue = ((JTextComponent)this._editorComponent).getText();
            this.setAsText(textValue);
        } else if (this._editorComponent instanceof JComboBox) {
            String newValue = this.getTextJComboBox((JComboBox)this._editorComponent);
            String oldValue = this.getAsText();
            if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
                return;
            }
            this.setAsText(newValue);
        } else {
            this.setAsText(this._propertyEditor.getAsText());
        }
    }

    public boolean alwaysUpdateXmlComponentFromModel() {
        return this._editorComponent instanceof JComboBox;
    }

    public void updateXmlComponentState() {
        if (this._editorComponent instanceof JComboBox) {
            PropertyEditorFactory2 avipe = this.getAttributeValueEditor();
            JComboBox combo = (JComboBox)this._editorComponent;
            ComboBoxModel model = (ComboBoxModel)avipe.getEditorComponentInfo().getProperties().get(MappedEditorFactoryInfo.MODEL);
            if (model != null) {
                combo.setModel(model);
            }
        }
    }

    public String getTextJComboBox(JComboBox mComboBox) {
        Object selectedItem = mComboBox.getSelectedItem();
        Object editingItem = mComboBox.getEditor().getItem();
        if (mComboBox.isEditable() && editingItem != null) {
            return editingItem.toString();
        }
        if (selectedItem instanceof AttributeValueItem) {
            AttributeValueItem selectedItemAsAttributeValue = (AttributeValueItem)selectedItem;
            try {
                return selectedItemAsAttributeValue.selectValue();
            }
            catch (PropertyVetoException e) {
                Assert.printStackTrace((Throwable)e);
                return null;
            }
        }
        if (selectedItem != null) {
            return selectedItem.toString();
        }
        return null;
    }

    public XmlComponentModel getXmlComponentModel() {
        return this._xmlComponentWrapper.getXmlComponentModel();
    }

    @Override
    public XmlComponentWrapper getXmlComponentWrapper() {
        return this._xmlComponentWrapper;
    }

    @Override
    public XmlComponentPropertyEditor setXmlComponentWrapper(XmlComponentWrapper xmlComponentWrapper) {
        this._xmlComponentWrapper = xmlComponentWrapper;
        return this;
    }

    @Override
    public void addChildFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removeChildFocusListener(FocusListener focusListener) {
    }

    @Override
    public XmlComponentLayoutOption getXmlComponentLayoutOption() {
        return null;
    }

    @Override
    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        if (this._xmlComponentWrapper != null && this._xmlComponentWrapper.getXmlWrappedComponent() != null) {
            this._xmlComponentWrapper.getXmlWrappedComponent().setEnabled(enabled);
        }
        return this;
    }

    @Override
    public boolean updatePropertyValue() {
        return true;
    }

    @Override
    public void dispose() {
    }

    public boolean suppressUpdatingXmlComponent() {
        return this._suppressUpdatingXmlComponent;
    }

    public void setSuppressUpdatingXmlComponent(boolean suppressUpdatingXmlComponent) {
        this._suppressUpdatingXmlComponent = suppressUpdatingXmlComponent;
    }

    protected void handleItemStateChanged(ItemEvent itemEvent) {
        if (this.getXmlComponentFlag()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String modelValue = AbstractXmlPropertyEditorFactoryDecorator.this.getXmlComponentModel().getModelValue();
                AbstractXmlPropertyEditorFactoryDecorator.this.updatePropertyValueFromXmlComponent();
                String currValue = AbstractXmlPropertyEditorFactoryDecorator.this.getAsText();
                if (!(currValue == null || currValue.equals(modelValue) || currValue.length() == 0 && modelValue == null)) {
                    AbstractXmlPropertyEditorFactoryDecorator.this.getXmlComponentWrapper().updateModelFromXmlComponent();
                    AbstractXmlPropertyEditorFactoryDecorator.this.getXmlComponentWrapper().updateChildXmlComponents();
                    AbstractXmlPropertyEditorFactoryDecorator.this.getXmlComponentWrapper().getXmlComponentModel().setSelection();
                }
            }
        });
    }

    public boolean getXmlComponentFlag() {
        return this._xmlComponentFlag;
    }

    public void setXmlComponentFlag(boolean xmlComponentFlag) {
        this._xmlComponentFlag = xmlComponentFlag;
    }
}

