/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlPropertyId;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.util.NameToStringUtils;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyFormLayoutGenerator {
    private PropertyModel _propertyModel;
    private XmlKey _inspectableKey;
    private Node _inspectableNode;
    private static final PropertyFormLayoutGenerator _INSTANCE = new PropertyFormLayoutGenerator();
    private static final String NAMESPACE = "http://xmlns.oracle.com/ide/extension";
    private static final String ID = "id";

    private PropertyFormLayoutGenerator() {
    }

    public static PropertyFormLayoutGenerator newInstance() {
        return _INSTANCE;
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        if (propertyModel == null) {
            throw new IllegalArgumentException("PropertyModel cannot be null!");
        }
        this._propertyModel = propertyModel;
    }

    public void setInspectableKey(XmlKey inspectableKey) {
        if (inspectableKey == null) {
            throw new IllegalArgumentException("XmlKey cannot be null!");
        }
        this._inspectableKey = inspectableKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL generatePIPropertyLayout() {
        try {
            if (this._getPropertyModel().getRowCount() == 0) {
                URL uRL = null;
                return uRL;
            }
            Document doc = this._createDocument();
            boolean success = this._generatePICategories(doc);
            if (success) {
                URL uRL = this._generateFile(doc);
                return uRL;
            }
            URL uRL = null;
            return uRL;
        }
        finally {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL generateCreatorPropertyLayout() {
        try {
            PropertyModel model = this._getPropertyModel();
            int rowCount = model.getRowCount();
            if (rowCount == 0) {
                URL uRL = null;
                return uRL;
            }
            ArrayList<Integer> rows = new ArrayList<Integer>(50);
            for (int i = 0; i < rowCount; ++i) {
                if (!this._isRelevantProperty(model, i)) continue;
                rows.add(i);
            }
            Document doc = this._createDocument();
            this._generateCategory(doc, "Common", "Common", rows, false);
            URL uRL = this._generateFile(doc);
            return uRL;
        }
        finally {
            this.dispose();
        }
    }

    public void dispose() {
        this._propertyModel = null;
        this._inspectableKey = null;
        this._inspectableNode = null;
    }

    private boolean _generatePICategories(Document doc) {
        Map<String, List<Integer>> map = this._collectCategoryInformation();
        if (map.isEmpty()) {
            return false;
        }
        Set<String> categorySet = map.keySet();
        List<String> categoryList = Arrays.asList(categorySet.toArray(new String[0]));
        Collections.sort(categoryList, this._getGroupComparator());
        String defaultCategory = categoryList.get(0);
        this._generateCategory(doc, defaultCategory, defaultCategory, map.get(defaultCategory), true);
        for (int i = 1; i < categoryList.size(); ++i) {
            String s = categoryList.get(i);
            this._generateCategory(doc, s, s, map.get(s), false);
        }
        return true;
    }

    private void _generateCategory(Document doc, String id, String name, List<Integer> rows, boolean isDefault) {
        Element root = doc.getDocumentElement();
        Element category = doc.createElementNS(NAMESPACE, "category-layout");
        category.setAttributeNodeNS(this._createAttr(doc, ID, id));
        category.setAttributeNodeNS(this._createAttr(doc, "title", name));
        if (isDefault) {
            category.setAttributeNodeNS(this._createAttr(doc, "selected", "true"));
        }
        Element displayGroup = doc.createElementNS(NAMESPACE, "display-group");
        displayGroup.setAttributeNodeNS(this._createAttr(doc, ID, id));
        category.appendChild(displayGroup);
        root.appendChild(category);
        this._generateProperties(doc, displayGroup, rows);
    }

    private void _generateProperties(Document doc, Element category, List<Integer> rows) {
        PropertyModel model = this._getPropertyModel();
        for (int i = 0; i < rows.size(); ++i) {
            String name = model.getPropertyName(rows.get(i).intValue());
            String id = this._getId(model, name, rows.get(i));
            if (id == null) continue;
            this._generateProperty(doc, category, id);
        }
    }

    private void _generateProperty(Document doc, Element category, String id) {
        Element property = doc.createElementNS(NAMESPACE, "property");
        property.setAttributeNodeNS(this._createAttr(doc, ID, id));
        category.appendChild(property);
    }

    private Document _createDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            DOMImplementation di = db.getDOMImplementation();
            Document layoutFile = di.createDocument(NAMESPACE, "property-form-layout", null);
            return layoutFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    private Map<String, List<Integer>> _collectCategoryInformation() {
        PropertyModel model = this._getPropertyModel();
        if (model == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Integer>> categories = new HashMap<String, List<Integer>>(10);
        int num = model.getRowCount();
        for (int i = 0; i < num; ++i) {
            if (!this._isRelevantProperty(model, i)) continue;
            String group = model.getPropertyGroup(i).getName(Locale.getDefault());
            ArrayList<Integer> rows = (ArrayList<Integer>)categories.get(group);
            if (rows == null) {
                rows = new ArrayList<Integer>(20);
                categories.put(group, rows);
            }
            rows.add(i);
        }
        return categories;
    }

    private boolean _isRelevantProperty(PropertyModel model, int row) {
        Object id = model.getPropertyID(row);
        if (id instanceof XmlPropertyId) {
            XmlPropertyId xmlId = (XmlPropertyId)id;
            if (xmlId.__getPropertyType().equals((Object)XmlPropertyId.PropertyType.ATTRIBUTE) || xmlId.__getPropertyType().equals((Object)XmlPropertyId.PropertyType.ELEMENT)) {
                return !model.getBooleanData(PropertyModel.COLUMN_IS_HIDDEN, row);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL _generateFile(Document doc) {
        URL url = null;
        OutputStream os = null;
        try {
            url = URLFileSystem.createTempFile((String)"layout", (String)".xml", null);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            os = URLFileSystem.openOutputStream((URL)url);
            transformer.transform(new DOMSource(doc), new StreamResult(os));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        return url;
    }

    private Attr _createAttr(Document doc, String qName, String value) {
        Attr a = doc.createAttributeNS(null, qName);
        a.setValue(value);
        return a;
    }

    private String _getId(PropertyModel model, String name, int row) {
        Object id = model.getPropertyID(row);
        if (id instanceof XmlPropertyId) {
            XmlKey xmlKey;
            XmlPropertyId xmlId = (XmlPropertyId)id;
            String key = null;
            List<XmlKey> xmlKeys = xmlId.__getPromotionPath();
            for (int i = 0; i < xmlKeys.size(); ++i) {
                xmlKey = xmlKeys.get(i);
                if (i == 0 && xmlKey.equals((Object)this._inspectableKey)) continue;
                String promotedKey = this.getSimpleXmlKeyString(xmlKey);
                key = key == null ? promotedKey : key + " " + promotedKey;
            }
            Object data = model.getData(XmlDomPropertyModel.COLUMN_XMLKEY, row);
            if (data instanceof XmlKey) {
                xmlKey = (XmlKey)data;
                String currKey = name;
                if (xmlId.__getPropertyType().equals((Object)XmlPropertyId.PropertyType.ATTRIBUTE)) {
                    QualifiedName attrQName = xmlKey.getAttributeQName();
                    currKey = attrQName != null && attrQName.getNamespace() != null ? NameToStringUtils.writeXmlKeyWithPrefixMappings((XmlKey)xmlKey).toString() : "@" + name;
                } else if (xmlId.__getPropertyType().equals((Object)XmlPropertyId.PropertyType.ELEMENT)) {
                    if (this._inspectableKey.equals((Object)xmlKey)) {
                        return NameToStringUtils.writeXmlKeyWithPrefixMappings((XmlKey)xmlKey, (String)this._inspectableKey.getNamespace()).toString();
                    }
                    currKey = this.getSimpleXmlKeyString(xmlKey);
                }
                key = key == null ? currKey : key + " " + currKey;
                return key;
            }
        }
        return null;
    }

    private String getSimpleXmlKeyString(XmlKey elementKey) {
        XmlKey writeXmlKey = elementKey;
        ArrayList qNames = new ArrayList();
        qNames.addAll(elementKey.getElementQNamePath());
        List inspectableQNames = this._inspectableKey.getElementQNamePath();
        qNames.removeAll(inspectableQNames);
        if (!qNames.isEmpty()) {
            writeXmlKey = ImmutableXmlKey.createElementKey(qNames);
        }
        return NameToStringUtils.writeXmlKeyWithPrefixMappings((XmlKey)writeXmlKey, (String)this._inspectableKey.getNamespace()).toString();
    }

    private PropertyModel _getPropertyModel() {
        if (this._propertyModel == null) {
            throw new IllegalStateException("PropertyModel cannot be null!");
        }
        return this._propertyModel;
    }

    private XmlKey _getInspectableKey() {
        if (this._inspectableKey == null) {
            throw new IllegalStateException("XmlKey cannot be null!");
        }
        return this._inspectableKey;
    }

    private Node _getInspectableNode() {
        if (this._inspectableNode == null) {
            this._inspectableNode = PropertyModelUtils.getAncestorNode(this._getPropertyModel(), 0);
        }
        return this._inspectableNode;
    }

    private BaseInspectorGui _getGui() {
        return PropertyModelUtils.getInspectorGui(this._getPropertyModel(), 0);
    }

    private String _getDefaultCategory() {
        XmlMetadataResolver resolver = this._getGui().getView().getXmlMetadataResolver();
        return resolver.getDefaultGroup(this._getInspectableNode(), this._getInspectableKey());
    }

    private Comparator<String> _getGroupComparator() {
        return new GroupComparator(this._getDefaultCategory(), Collator.getInstance(this._getGui().getGuiContext().getLocale()));
    }

    private class GroupComparator
    implements Comparator<String> {
        private final String _defaultGroup;
        private final Collator _collator;

        GroupComparator(String defaultGroup, Collator collator) {
            this._defaultGroup = defaultGroup;
            this._collator = collator;
        }

        @Override
        public int compare(String s1, String s2) {
            if (this._defaultGroup == null) {
                return this._collator.compare(s1, s2);
            }
            if (s1.equals(this._defaultGroup)) {
                return -1;
            }
            if (s2.equals(this._defaultGroup)) {
                return 1;
            }
            return this._collator.compare(s1, s2);
        }
    }
}

