/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.inspector.CustomEditorAction;
import oracle.bali.inspector.CustomEditorActionSource;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.xml.gui.base.inspector.AbstractAttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.ComboBoxSupport;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.editors.EditorUtils;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.DefaultAttributeValueItem;
import oracle.javatools.util.ModelUtil;

class AttributeValueItemPropertyEditor
extends AbstractAttributeValueItemPropertyEditor {
    private final PropertyEditorFactory2 _realBase;

    public static PropertyEditorFactory2 create(PropertyRow propertyRow, PropertyEditorFactory2 toProxy) {
        return new AttributeValueItemPropertyEditor(toProxy, propertyRow);
    }

    private AttributeValueItemPropertyEditor(PropertyEditorFactory2 base, PropertyRow propertyRow) {
        super(propertyRow);
        this._realBase = base;
    }

    public void setValue(Object value) {
        this._realBase.setValue(value);
    }

    public Object getValue() {
        return this._realBase.getValue();
    }

    public String getAsText() {
        if (this.getValue() == null) {
            return null;
        }
        return this._realBase.getAsText();
    }

    public void setAsText(String s) {
        this._realBase.setAsText(s);
    }

    public boolean isPaintable() {
        return this._realBase.isPaintable();
    }

    public void paintValue(Graphics g, Rectangle r) {
        this._realBase.paintValue(g, r);
    }

    public boolean hasInlineEditor() {
        return true;
    }

    public Component getInlineEditor() {
        return super.getInlineEditor();
    }

    public EditorComponentInfo getEditorComponentInfo() {
        EditorComponentInfo beci = this._realBase.getEditorComponentInfo();
        EditorComponentInfo eci = ComboBoxSupport.getComboBoxInfo(this);
        return this._getEditorComponentInfo(beci, eci);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._realBase.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._realBase.addPropertyChangeListener(listener);
    }

    public CustomEditorAction customEditorAction() {
        if (this._realBase instanceof CustomEditorActionSource) {
            return ((CustomEditorActionSource)this._realBase).customEditorAction();
        }
        return null;
    }

    public void setPropertyValueApplier(PropertyValueApplier propertyValueApplier) {
        this._realBase.setPropertyValueApplier(propertyValueApplier);
    }

    public PropertyValueApplier getPropertyValueApplier() {
        return this._realBase.getPropertyValueApplier();
    }

    boolean __isRowSet() {
        return this.getRow().isSet();
    }

    static boolean __equalsSelectedValue(AttributeValueItem item, String value) {
        if (item instanceof DefaultAttributeValueItem) {
            return ((DefaultAttributeValueItem)item).equalsSelectedValue(value);
        }
        return ModelUtil.areEqual((Object)item.getDisplayText(), (Object)value);
    }

    String __getBaseEditorComponentIdentifier() {
        EditorComponentInfo beci = this._realBase.getEditorComponentInfo();
        if (beci == null) {
            return null;
        }
        return beci.getComponentIdentifier();
    }

    String __getAsTextOrNull() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return this.getAsText();
    }

    String __getAsTextOrDefault() {
        if (this.__isRowSet()) {
            return this.getAsText();
        }
        return this.getDefaultValue();
    }

    private EditorComponentInfo _getEditorComponentInfo(EditorComponentInfo beci, EditorComponentInfo eci) {
        String id = this.__getBaseEditorComponentIdentifier();
        Map additionalProperties = Collections.emptyMap();
        if (eci != null) {
            id = eci.getComponentIdentifier();
            additionalProperties = eci.getProperties();
        }
        if (id == null) {
            id = MappedEditorFactoryInfo.TEXT_FIELD;
        }
        Map baseProperties = beci.getProperties();
        HashMap<String, Object> newProperties = new HashMap<String, Object>(baseProperties.size() + additionalProperties.size());
        Set basePropertyNames = baseProperties.keySet();
        Set additionalPropertyNames = additionalProperties.keySet();
        for (String s : basePropertyNames) {
            newProperties.put(s, baseProperties.get(s));
        }
        for (String s : additionalPropertyNames) {
            newProperties.put(s, additionalProperties.get(s));
        }
        this._addAddtionalProperties(id, newProperties);
        return EditorUtils.createEditorComponentInfo(id, newProperties);
    }

    private void _addAddtionalProperties(String id, Map<String, Object> properties) {
        this._addCommonProperties(properties);
        this._addComponentSpecificProperties(id, properties);
    }

    private void _addCommonProperties(Map<String, Object> properties) {
        properties.put(MappedEditorFactoryInfo.EDITABLE, this.getRow().isWritable());
    }

    private void _addComponentSpecificProperties(String id, Map<String, Object> properties) {
        if (id.equals(MappedEditorFactoryInfo.TEXT_FIELD)) {
            boolean disabled = this.getRow().inlineEditingDisabled();
            boolean writable = this.getRow().isWritable();
            properties.put(MappedEditorFactoryInfo.EDITABLE, !disabled && writable);
        } else if (id.equals(MappedEditorFactoryInfo.COMBO_BOX)) {
            properties.put(MappedEditorFactoryInfo.EDITABLE, !this.isConstrainedToEnumeration());
        }
    }
}

