/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.javatools.logging.LogUtils;

public class GuiEventProcessor {
    public void processEvent(XmlGui gui, XmlModelEvent event) {
        this.passEventToGui(gui, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void passEventToGui(XmlGui gui, XmlModelEvent event) {
        XmlView view = gui.getView();
        view.acquireReadLock();
        try {
            if (!gui.getGuiContext().isDisposed()) {
                gui.handleModelChangeEvent(event);
                gui.__notifyGuiListenersModelChange(event);
            }
        }
        catch (Throwable t) {
            LogUtils.log((Logger)gui.getLogger(), (Level)Level.WARNING, (String)"Exception dispatching event to gui {0}. Event={1}", (Object[])new Object[]{gui, event}, (Throwable)t);
        }
        finally {
            view.releaseReadLock();
        }
    }
}

