/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;

public final class CollapseWhitespaceMode
extends WhitespaceMode {
    protected CollapseWhitespaceMode() {
        super("collapse");
    }

    @Override
    public Boolean allowsAddingExtraWhitespace(DomPosition pos) {
        return Boolean.TRUE;
    }

    @Override
    protected WhitespaceResult applyImpl(String input) {
        return CollapseWhitespaceMode.__doApply(input, true);
    }

    static WhitespaceResult __doApply(String input, boolean shouldTrimEnds) {
        int i;
        WhitespaceResult result = new WhitespaceResult();
        boolean didAnything = false;
        int trimmedStart = WhitespaceUtils.getTrimmedStart(input);
        for (int i2 = 0; i2 < trimmedStart; ++i2) {
            if (shouldTrimEnds || i2 < trimmedStart - 1) {
                didAnything = true;
                result.markSingleWhitespaceChar();
                continue;
            }
            if (input.charAt(i2) != ' ') {
                didAnything = true;
            }
            result.appendToValue(' ');
        }
        int trimmedEnd = shouldTrimEnds ? WhitespaceUtils.getTrimmedEnd(input, trimmedStart) : input.length();
        boolean lastWasWhitespace = false;
        for (i = trimmedStart; i < trimmedEnd; ++i) {
            char c = input.charAt(i);
            if (WhitespaceUtils.isXmlWhitespaceChar(c)) {
                if (lastWasWhitespace) {
                    didAnything = true;
                    result.markSingleWhitespaceChar();
                } else {
                    if (c != ' ') {
                        didAnything = true;
                    }
                    result.appendToValue(' ');
                }
                lastWasWhitespace = true;
                continue;
            }
            result.appendToValue(c);
            lastWasWhitespace = false;
        }
        for (i = trimmedEnd; i < input.length(); ++i) {
            result.markSingleWhitespaceChar();
            didAnything = true;
        }
        if (didAnything) {
            return result;
        }
        return null;
    }
}

