/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.DomCommitException;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.impl.ChangeRecord;
import oracle.bali.xml.dom.impl.ChildDomModelTransaction;
import oracle.bali.xml.dom.impl.DomChangesUndoableEditImpl;
import oracle.bali.xml.dom.impl.DomModelImpl;
import oracle.bali.xml.dom.impl.DomModelTransaction;
import oracle.bali.xml.dom.impl.UndoDomModelTransaction;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class RootDomModelTransaction
extends DomModelTransaction {
    private int _changeCount;
    private transient Node _changeTarget;
    private transient int _changeFlags;

    public RootDomModelTransaction(DomModelImpl model, RootDomModelTransaction prevRoot) {
        super(model);
        this._changeCount = prevRoot.getChangeCount() + 1;
        this.transferListeners(prevRoot);
    }

    public RootDomModelTransaction(DomModelImpl model) {
        super(model);
    }

    public void fireEntireDocumentChangedEvent(Map propertyChanges) {
        this.fireSubtreeChanged(this.getModel().getDocument(), 31, Collections.EMPTY_LIST, propertyChanges, null, false);
    }

    public UndoDomModelTransaction startUndoTransaction() {
        return this._startUndoRedoTransaction(true);
    }

    public UndoDomModelTransaction startRedoTransaction() {
        return this._startUndoRedoTransaction(false);
    }

    private UndoDomModelTransaction _startUndoRedoTransaction(boolean isUndo) {
        UndoDomModelTransaction child = new UndoDomModelTransaction(this.getModel(), (DomModelTransaction)this, isUndo);
        this.setNestedTransaction(child);
        return child;
    }

    @Override
    public DomCommitException precommit() {
        throw new IllegalStateException("Root transactions can't be comitted");
    }

    @Override
    public DomModelTransaction commit() {
        throw new IllegalStateException("Root transactions can't be comitted");
    }

    @Override
    public DomModelTransaction rollback() {
        throw new IllegalStateException("Root transactions can't be rolled back");
    }

    public String toString() {
        return super.toString() + "[change=" + this._changeCount + "]";
    }

    public int getChangeCount() {
        return this._changeCount;
    }

    @Override
    protected DomModelTransaction getParent() {
        return null;
    }

    @Override
    protected Node getChangeTarget() {
        return this._changeTarget;
    }

    @Override
    protected int getChangeFlags() {
        return this._changeFlags;
    }

    @Override
    protected DomCommitException precommitDomChanges(ChildDomModelTransaction child, int changeIncrement) {
        if (changeIncrement != 0) {
            List changeList = child.getMutationChanges();
            DomChange[] changeArr = DomChangesUndoableEditImpl.flattenDomChangeListToArray(changeList);
            return this.getModel().__precommitDomChanges(changeArr);
        }
        return null;
    }

    @Override
    protected void updateChangeTarget(ChildDomModelTransaction child, int changeIncrement) {
        child.__disposeAllRemovedSubtreeListeners();
        this._changeTarget = child.getChangeTarget();
        this._changeFlags = child.getChangeFlags();
        if (changeIncrement != 0) {
            this._changeCount += changeIncrement;
            if (changeIncrement > 0 && child.modifiesUndoStack()) {
                this.getModel().__addEdit(new DomChangesUndoableEditImpl(this.getModel(), child.getDescription(), child.getMutationChanges()));
            }
        }
    }

    @Override
    protected void commitChild(int changeIncrement) {
        try {
            super.commitChild(changeIncrement);
        }
        finally {
            this._changeTarget = null;
            this._changeFlags = 0;
        }
    }

    @Override
    protected void handleMutationEventHook(Node mergeNode, int changeFlag, ChangeRecord changeRecord, MutationEvent mEvent) {
        DomChange change = changeRecord.getChange();
        this.getModel().__addEdit(new DomChangesUndoableEditImpl(this.getModel(), change));
        ++this._changeCount;
    }
}

