/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;

public abstract class DomChangesUndoableEdit
extends AbstractUndoableEdit {
    private ArrayList _subEdits = null;
    private DomChange[] _changeInfos;

    protected DomChangesUndoableEdit(DomChange[] changes) {
        this._changeInfos = changes;
    }

    public void processChanges(DomChangeHandler handler) {
        for (int i = 0; i < this.getChangeCount(); ++i) {
            this._process(this.getChange(i), handler);
        }
    }

    public void processChangesInReverse(DomChangeHandler handler) {
        for (int i = this.getChangeCount() - 1; i >= 0; --i) {
            this._process(this.getChange(i), handler);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this._subEdits != null) {
            for (int i = 0; i < this._subEdits.size(); ++i) {
                UndoableEdit currUndoableEdit = (UndoableEdit)this._subEdits.get(i);
                currUndoableEdit.undo();
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this._subEdits != null) {
            for (int i = 0; i < this._subEdits.size(); ++i) {
                UndoableEdit currUndoableEdit = (UndoableEdit)this._subEdits.get(i);
                currUndoableEdit.redo();
            }
        }
    }

    @Override
    public final boolean addEdit(UndoableEdit anEdit) {
        if (this.getClass() == anEdit.getClass()) {
            DomChangesUndoableEdit other = (DomChangesUndoableEdit)anEdit;
            String ourName = this.getPresentationName();
            String otherName = other.getPresentationName();
            boolean namesOK = ourName == null ? otherName == null : ourName.equals(otherName);
            if (namesOK && this.canAddEdit(other)) {
                int numSubEdits;
                DomChange otherDomChange;
                DomChange ourDomChange;
                int ourCount = this.getChangeCount();
                int otherCount = other.getChangeCount();
                if (ourCount >= 1 && otherCount >= 1 && (ourDomChange = this.getChange(ourCount - 1)).canMergeWith(otherDomChange = other.getChange(0)) && (numSubEdits = this._length(this._subEdits)) <= 1 && this._length(other._subEdits) == numSubEdits) {
                    UndoableEdit otherSubEdit;
                    UndoableEdit ourSubEdit;
                    if (numSubEdits == 1 && !(ourSubEdit = (UndoableEdit)this._subEdits.get(0)).addEdit(otherSubEdit = (UndoableEdit)other._subEdits.get(0))) {
                        return false;
                    }
                    int newTotal = ourCount + otherCount;
                    DomChange[] newInfos = new DomChange[newTotal];
                    System.arraycopy(this._changeInfos, 0, newInfos, 0, ourCount);
                    System.arraycopy(other._changeInfos, 0, newInfos, ourCount, otherCount);
                    this._changeInfos = newInfos;
                    this.addEditImpl(other);
                    return true;
                }
            }
        }
        return false;
    }

    public void addSubEdit(UndoableEdit anEdit) {
        if (this._subEdits == null) {
            this._subEdits = new ArrayList(1);
        }
        this._subEdits.add(anEdit);
    }

    @Override
    public void die() {
        super.die();
        if (this._subEdits != null) {
            for (int i = 0; i < this._subEdits.size(); ++i) {
                ((UndoableEdit)this._subEdits.get(i)).die();
            }
            this._subEdits = null;
        }
        this._changeInfos = null;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("\nname=");
        buf.append(this.getPresentationName());
        for (int i = 0; i < this.getChangeCount(); ++i) {
            buf.append("\nchange #");
            buf.append(i);
            buf.append(":");
            buf.append(this.getChange(i));
        }
        buf.append("\nsubedits: ");
        buf.append(this._subEdits);
        return buf.toString();
    }

    protected final int getChangeCount() {
        return this._changeInfos.length;
    }

    protected final DomChange getChange(int i) {
        return this._changeInfos[i];
    }

    protected boolean canAddEdit(DomChangesUndoableEdit other) {
        return true;
    }

    protected void addEditImpl(DomChangesUndoableEdit other) {
    }

    private int _length(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    private void _process(DomChange change, DomChangeHandler handler) {
        change.process(handler);
    }
}

