/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.BufferDomRelatedChange;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import org.w3c.dom.Node;

class MapSubtreeLocatorChange
extends BufferDomRelatedChange {
    private final NodeRef _subtreeRoot;
    private final boolean _isInsert;
    private final ArrayList _nodeRefs = new ArrayList();
    private final ArrayList _oldLocators = new ArrayList();
    private final ArrayList _newLocators = new ArrayList();
    private static final Logger _LOGGER = Logger.getLogger(MapSubtreeLocatorChange.class.getName());

    public MapSubtreeLocatorChange(Node subtreeRoot, boolean isInsert) {
        this(NodeRefFactory.getNodeRef((Node)subtreeRoot), isInsert);
    }

    public MapSubtreeLocatorChange(NodeRef subtreeRootRef, boolean isInsert) {
        this._subtreeRoot = subtreeRootRef;
        this._isInsert = isInsert;
    }

    public void addNode(Node node, Locator oldLocator, Locator newLocator) {
        this.addNode(NodeRefFactory.getNodeRef((Node)node), oldLocator, newLocator);
    }

    public void addNode(NodeRef ref, Locator oldLocator, Locator newLocator) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "AddNode: {0} from {1} to {2}", new Object[]{ref, oldLocator, newLocator});
        }
        this._nodeRefs.add(ref);
        this._oldLocators.add(oldLocator);
        this._newLocators.add(newLocator);
    }

    public void doneAddingNodes() {
        this._nodeRefs.trimToSize();
        this._oldLocators.trimToSize();
        this._newLocators.trimToSize();
    }

    @Override
    protected void preUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._isInsert) {
            Node subtreeRoot = TextSyncUtils.getNode(model, this._subtreeRoot);
            plugin.nodeSubtreeRemoved(subtreeRoot);
            this._mapToLocators(model, plugin, this._oldLocators);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    @Override
    protected void postUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (!this._isInsert) {
            Node subtreeRoot = TextSyncUtils.getNode(model, this._subtreeRoot);
            this._mapToLocators(model, plugin, this._oldLocators);
            plugin.nodeSubtreeInserted(subtreeRoot);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    @Override
    protected void postRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._isInsert) {
            Node subtreeRoot = TextSyncUtils.getNode(model, this._subtreeRoot);
            this._mapToLocators(model, plugin, this._newLocators);
            plugin.nodeSubtreeInserted(subtreeRoot);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    @Override
    protected void preRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (!this._isInsert) {
            Node subtreeRoot = TextSyncUtils.getNode(model, this._subtreeRoot);
            plugin.nodeSubtreeRemoved(subtreeRoot);
            this._mapToLocators(model, plugin, this._newLocators);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    private void _mapToLocators(DomModel model, BufferDomModel plugin, ArrayList locators) {
        for (int i = 0; i < this._nodeRefs.size(); ++i) {
            NodeRef ref = (NodeRef)this._nodeRefs.get(i);
            Locator locator = (Locator)locators.get(i);
            Node node = TextSyncUtils.getNode(model, ref);
            locator = Locator.getCopy(locator);
            if (_LOGGER.isLoggable(Level.FINEST)) {
                _LOGGER.log(Level.FINEST, "MapSubtree: {0} --> {1}", new Object[]{node, locator});
            }
            plugin.mapNodeToLocator(node, locator);
        }
    }
}

