/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.beanmodel.BeanTask;
import oracle.bali.xml.beanmodel.apigeneration.APIGenerator;
import oracle.bali.xml.beanmodel.apigeneration.Options;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TaskUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.AttributeGroup;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.CoreMetadataEvaluator;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.model.AbstractModel;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModel;

public final class GenerationManager {
    private JavaModel _javaModel;
    private GrammarProvider _grammarProvider;
    private MetadataProvider _metadataProvider;
    private Options _options = new Options();
    private static final GenerationManager _generator = new GenerationManager();

    private GenerationManager() {
    }

    public static GenerationManager getInstance() {
        return _generator;
    }

    public void generate() {
        try {
            if (this._grammarProvider == null) {
                throw new IllegalStateException("Can't generate APIs without a GrammarProvider!");
            }
            this._setDefaultOptions();
            this._generate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void setGrammarProvider(GrammarProvider grammarProvider) {
        this._grammarProvider = grammarProvider;
    }

    public void setMetadataProvider(MetadataProvider metadataProvider) {
        this._metadataProvider = metadataProvider;
    }

    public void reset() {
        this._options.reset();
    }

    public void addSkipNamespace(String namespace) {
        this._options.addSkipNamespace(namespace);
    }

    public void addTreatAsSimple(String typeName) {
        this._options.addTreatAsSimple(typeName);
    }

    public void addTypeMapping(String fromType, String toType) {
        this._options.addTypeMapping(fromType, toType);
    }

    public void addEnumOverride(String enumType, Set<String> values) {
        this._options.addEnumOverride(enumType, values);
    }

    public void setSourceDirectory(URL sourceDir) {
        this._options.setSourceDirectory(sourceDir);
    }

    public void setClassPath(String classPath) {
        this._options.setClassPath(classPath);
    }

    public void setGenerateAttrDefaultValues(boolean useDefault) {
        this._options.setGenerateAttrDefaultValues(useDefault);
    }

    public void setGenerateModelGroups(boolean generateModelGroups) {
        this._options.setGenerateModelGroups(generateModelGroups);
    }

    private void _setDefaultOptions() throws Exception {
        if (this._options.getSourceDirectory() == null) {
            this._options.setSourceDirectory(this._getDefaultSourceDir());
        }
        this._javaModel = JavaModel.getInstance((URLPath)this._getSourcePath(), (URLPath)this._options.getClassPath());
    }

    private URL _getDefaultSourceDir() throws Exception {
        return new URL("file:///" + System.getProperty("user.home"));
    }

    private URLPath _getSourcePath() throws Exception {
        return new URLPath(this._options.getSourceDirectory());
    }

    private void _generate() throws Exception {
        this._populateAttributeGroupMap();
        CoreMetadataEvaluator metadataEvaluator = new CoreMetadataEvaluator(this._metadataProvider, new GrammarResolver(this._grammarProvider));
        Map grammarMap = this._grammarProvider.getGrammarMap();
        Set namespaces = grammarMap.keySet();
        for (String ns : namespaces) {
            Grammar grammar = (Grammar)grammarMap.get(ns);
            APIGenerator generator = APIGenerator.createGenerator(grammar, (MetadataEvaluator)metadataEvaluator, this._options);
            TaskUtils.startTimeTracking("GenerationManager._generate", "Beginning API generation for namespace: " + ns);
            generator.generate(this._javaModel);
            TaskUtils.endTimeTracking("GenerationManager._generate", "Finished API generation for namespace: " + ns);
        }
    }

    private void _populateAttributeGroupMap() {
        HashMap<AttributeDef, AttributeGroup> attrMap = new HashMap<AttributeDef, AttributeGroup>();
        Map grammarMap = this._grammarProvider.getGrammarMap();
        Set namespaces = grammarMap.keySet();
        for (String ns : namespaces) {
            Grammar grammar = (Grammar)grammarMap.get(ns);
            Collection groups = grammar.getAttributeGroups();
            for (AttributeGroup group : groups) {
                Collection gcs = group.getComponents();
                for (GrammarComponent gc : gcs) {
                    if (!(gc instanceof AttributeDef)) continue;
                    attrMap.put((AttributeDef)gc, group);
                }
            }
        }
        this._options.setAttributeGroupMap(attrMap);
    }

    static {
        MetadataSchemaRegistry.getInstance().registerSchema(AbstractModel.class.getResource("metadata/XmlModelMetadata.xsd"));
        MetadataSchemaRegistry.getInstance().registerSchema(BeanTask.class.getResource("metadata/XmlBeanModelMetadata.xsd"));
    }
}

